/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.movimentacaomensal;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class MovimentacaoMensalJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovimentacaoMensalJobListener.class);
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String MOVIMENTACAO_MENSAL = JobType.SIMAM_MOVIMENTACAO_MENSAL.getTipo();
    private final NotificacaoClient notificacaoClient;

    public MovimentacaoMensalJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao notificacao = Notificacao.builder().text("SIM-AM - Movimenta\u00e7\u00e3o Mensal iniciada").title(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Movimenta\u00e7\u00e3o Mensal - %s -> %s", dataInicial.toString(), dataFinal.toString())).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)MOVIMENTACAO_MENSAL).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("SIM-AM - Movimenta\u00e7\u00e3o Mensal finalizada com sucesso").title(String.format("Os dados referentes a Movimenta\u00e7\u00e3o Mensal no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial.toString(), dataFinal.toString())).metadata(JOB_TYPE, (Object)MOVIMENTACAO_MENSAL).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Movimenta\u00e7\u00e3o Mensal").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)MOVIMENTACAO_MENSAL).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

