/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldomovimentacaomensal;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ImplantacaoSaldoMovimentacaoMensalJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplantacaoSaldoMovimentacaoMensalJobListener.class);
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    private static final String JOB_TYPE = "jobType";
    private static final String IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL = JobType.SIMAM_IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL.getTipo();
    private final NotificacaoClient notificacaoClient;

    public ImplantacaoSaldoMovimentacaoMensalJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Notificacao notificacao = Notificacao.builder().text("SIM-AM - Implanta\u00e7\u00e3o Saldo x Movimenta\u00e7\u00e3o Mensal iniciada").title(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Implanta\u00e7\u00e3o Saldo x Movimenta\u00e7\u00e3o Mensal - %s ", exercicio.toString())).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("SIM-AM - Implanta\u00e7\u00e3o Saldo x Movimenta\u00e7\u00e3o Mensal finalizada com sucesso").title(String.format("Os dados referentes a Implanta\u00e7\u00e3o Saldo x Movimenta\u00e7\u00e3o Mensal - %s foram gerados com sucesso.", exercicio.toString())).metadata(JOB_TYPE, (Object)IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Implanta\u00e7\u00e3o Saldo x Movimenta\u00e7\u00e3o Mensal").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)IMPLANTACAO_SALDO_MOVIMENTACAO_MENSAL).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

