/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaomonetariada;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoAtualizacaoMonetariaCreditoDAJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoAtualizacaoMonetariaCreditoDAJobListener.class);
    private static String PREFIXO = "SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String ESTORNO_ATUALIZACAO_CREDITO = JobType.SIMAM_ESTORNO_ATUALIZACAO_MONETARIA_CREDITO_DA.getTipo();
    private final NotificacaoClient notificacaoClient;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao notificacao = Notificacao.builder().text(PREFIXO + "iniciado").title(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - %s -> %s", dataInicial.toString(), dataFinal.toString())).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text(PREFIXO + "finalizado com sucesso").title(String.format("Os dados referentes a Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial.toString(), dataFinal.toString())).metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoDAJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }
}

