/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito;

import br.com.elotech.tributos.domain.simam.DeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoIsencao;
import br.com.elotech.tributos.domain.simam.DeducaoPagamento;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.TipoDeducaoCredito;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCancelamentoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoCreditoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoIsencaoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoPagamentoRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class DeducaoCreditoBatchWriter
implements ItemWriter<TipoDeducaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeducaoCreditoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final DeducaoCreditoCancelamentoRepository deducaoCreditoCancelamentoRepository;
    private final DeducaoCreditoPagamentoRepository deducaoCreditoPagamentoRepository;
    private final DeducaoCreditoIsencaoRepository deducaoCreditoIsencaoRepository;
    private final DeducaoCreditoCreditoRepository deducaoCreditoCreditoRepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Dedu\u00e7\u00e3o Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoDeducaoCredito> items) {
        List cancelamentos = items.stream().filter(item -> item instanceof DeducaoCancelamento).map(DeducaoCancelamento.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(item -> item instanceof DeducaoPagamento).map(DeducaoPagamento.class::cast).collect(Collectors.toList());
        List isencoes = items.stream().filter(item -> item instanceof DeducaoIsencao).map(DeducaoIsencao.class::cast).collect(Collectors.toList());
        List creditos = items.stream().filter(item -> item instanceof DeducaoCreditoCredito).map(DeducaoCreditoCredito.class::cast).collect(Collectors.toList());
        this.deducaoCreditoCancelamentoRepository.saveAll(cancelamentos);
        this.deducaoCreditoPagamentoRepository.saveAll(pagamentos);
        this.deducaoCreditoIsencaoRepository.saveAll(isencoes);
        this.deducaoCreditoCreditoRepository.saveAll(creditos);
        this.entityManager.flush();
    }

    @Generated
    public DeducaoCreditoBatchWriter(EntityManager entityManager, DeducaoCreditoCancelamentoRepository deducaoCreditoCancelamentoRepository, DeducaoCreditoPagamentoRepository deducaoCreditoPagamentoRepository, DeducaoCreditoIsencaoRepository deducaoCreditoIsencaoRepository, DeducaoCreditoCreditoRepository deducaoCreditoCreditoRepository) {
        this.entityManager = entityManager;
        this.deducaoCreditoCancelamentoRepository = deducaoCreditoCancelamentoRepository;
        this.deducaoCreditoPagamentoRepository = deducaoCreditoPagamentoRepository;
        this.deducaoCreditoIsencaoRepository = deducaoCreditoIsencaoRepository;
        this.deducaoCreditoCreditoRepository = deducaoCreditoCreditoRepository;
    }
}

