/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoResultado;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAvaliacao;
import br.com.elotech.tributos.service.CadastroImobiliarioAvaliacaoService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class GeracaoDebitoCalculoBatchWriter
implements ItemWriter<CalculoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeracaoDebitoCalculoBatchWriter.class);
    private final CalculoService calculoService;
    private final CalculoCadastroService calculoCadastroService;
    private final EntityManager entityManager;
    private final CadastroImobiliarioAvaliacaoService avaliacaoService;
    private StepExecution stepExecution;

    public GeracaoDebitoCalculoBatchWriter(CalculoService calculoService, CalculoCadastroService calculoCadastroService, EntityManager entityManager, CadastroImobiliarioAvaliacaoService avaliacaoService) {
        this.calculoService = calculoService;
        this.calculoCadastroService = calculoCadastroService;
        this.entityManager = entityManager;
        this.avaliacaoService = avaliacaoService;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends CalculoCadastro> items) {
        LOGGER.info("Salvando a gera\u00e7\u00e3o de d\u00e9bitos dos cadastros. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        items.forEach(calculoCadastro -> this.calculoCadastroService.save((EloEntity)calculoCadastro, null));
        items.stream().filter(calculoCadastro -> TipoDivida.IPTU.equals(Optional.ofNullable(calculoCadastro.getDivida()).map(Divida::getTipoDivida).orElse(null))).forEach(arg_0 -> this.createNewCadastroImobiliarioAvaliacao(arg_0));
        this.entityManager.flush();
    }

    private void createNewCadastroImobiliarioAvaliacao(CalculoCadastro calculoCadastro) {
        BigDecimal valorPredialSomado = BigDecimal.ZERO;
        BigDecimal valorTerritorialSomado = BigDecimal.ZERO;
        if (!calculoCadastro.getResultados().isEmpty()) {
            valorTerritorialSomado = this.sumValoresTerritoriais(calculoCadastro.getResultados());
            valorPredialSomado = this.sumValoresPrediais(calculoCadastro.getResultados());
        }
        if (this.areTheValuesValidForGenaration(valorPredialSomado, valorTerritorialSomado)) {
            this.newCadastroImobiliarioAvaliacao(calculoCadastro, valorPredialSomado, valorTerritorialSomado);
        }
    }

    public BigDecimal sumValoresTerritoriais(List<CalculoResultado> resultados) {
        return resultados.stream().map(resultado -> Optional.ofNullable(resultado.getValorVenalTerritorial()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal sumValoresPrediais(List<CalculoResultado> resultados) {
        return resultados.stream().map(resultado -> Optional.ofNullable(resultado.getValorVenalPredial()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public boolean areTheValuesValidForGenaration(BigDecimal predial, BigDecimal territorial) {
        return predial.compareTo(BigDecimal.ZERO) > 0 && territorial.compareTo(BigDecimal.ZERO) > 0;
    }

    public void newCadastroImobiliarioAvaliacao(CalculoCadastro calculoCadastro, BigDecimal valorPredial, BigDecimal valorTerritorial) {
        CadastroImobiliarioAvaliacao avaliacao = CadastroImobiliarioAvaliacao.fromGeracaoDebito((CalculoCadastro)calculoCadastro, (BigDecimal)valorPredial, (BigDecimal)valorTerritorial);
        this.avaliacaoService.save((EloEntity)avaliacao, null);
    }
}

