/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.enviopeticaoprocuradoria;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.EnvioLotePeticao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.documento.EnvioLotePeticaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EnvioPeticaoProcuradoriaJobListener
extends JobExecutionListenerSupport {
    private static final String ID = "idLote";
    private static final String ID_ENVIO_LOTE_PETICAO = "idEnvioLotePeticao";
    private static final String JOB_TYPE = "jobType";
    private static final String ENVIA_LOTE_PETICAO_PROCURADORIA = JobType.ENVIA_LOTE_PETICAO_PROCURADORIA.getTipo();
    private final NotificacaoClient notificacaoClient;
    private final EnvioLotePeticaoRepository envioPeticaoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLote = jobExecution.getJobParameters().getLong(ID);
        Long idEnvioLotePeticao = jobExecution.getJobParameters().getLong(ID_ENVIO_LOTE_PETICAO);
        Optional envioLotePeticao = this.envioPeticaoRepository.findById((Object)idEnvioLotePeticao);
        if (!envioLotePeticao.isPresent()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar nenhum Lote Envio Peti\u00e7\u00e3o com id: %d.", idEnvioLotePeticao));
        }
        EnvioLotePeticao lotePeticao = (EnvioLotePeticao)envioLotePeticao.get();
        lotePeticao.setIdJob(BatchJobExecution.of((JobExecution)jobExecution));
        this.envioPeticaoRepository.saveAndFlush((Object)lotePeticao);
        Notificacao notificacao = Notificacao.builder().text("Iniciada a gera\u00e7\u00e3o do arquivo agrupado para envio para Procuradoria.").title(String.format("Foi iniciada a gera\u00e7\u00e3o do arquivo agrupado com a Peti\u00e7\u00e3o e a CDAs do Lote %d.", idLote)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)ENVIA_LOTE_PETICAO_PROCURADORIA).metadata(ID, (Object)idLote).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        Long idLote = jobExecution.getJobParameters().getLong(ID);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Gera\u00e7\u00e3o do arquivo agrupado para envio para Procuradoria finalizada com sucesso.").title(String.format("Arquivo agrupado da Peti\u00e7\u00f5es do Lote %d disponibilizado para a Procuadoria.", idLote)).metadata(JOB_TYPE, (Object)ENVIA_LOTE_PETICAO_PROCURADORIA).metadata(ID, (Object)idLote);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o do arquivo agrupado para envio para Procuradoria.").title(String.format("N\u00e3o foi poss\u00edvel gerar o arquivo do Lote %d para a Procuradoria.", idLote)).metadata(JOB_TYPE, (Object)ENVIA_LOTE_PETICAO_PROCURADORIA).metadata(ID, (Object)idLote).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public EnvioPeticaoProcuradoriaJobListener(NotificacaoClient notificacaoClient, EnvioLotePeticaoRepository envioPeticaoRepository) {
        this.notificacaoClient = notificacaoClient;
        this.envioPeticaoRepository = envioPeticaoRepository;
    }
}

