/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.validacaoendereco;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ValidacaoEnderecoJobListener
extends JobExecutionListenerSupport {
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    private static final String ID_COMUNICADO = "idComunicado";
    private final ComunicadoRepository comunicadoRepository;
    private static final String JOB_TYPE = "jobType";
    private static final String VALIDACAO_ENDERECO = JobType.COMUNICADO_VALIDACAO_ENDERECOS.getTipo();
    private final NotificacaoClient notificacaoClient;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Long idComunicado = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ID_COMUNICADO));
        Notificacao notificacao = Notificacao.builder().text("COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os - iniciada").title(String.format("Foi iniciada a Valida\u00e7\u00e3o de Endere\u00e7os para o comunicado %d do exercicio: %d", idComunicado, exercicio)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)VALIDACAO_ENDERECO).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(ID_COMUNICADO, (Object)idComunicado).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idComunicado = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ID_COMUNICADO));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text(String.format("Os endere\u00e7os do comunicado %d foram validados onde poss\u00edvel.", idComunicado)).title("Valida\u00e7\u00e3o de endere\u00e7os - finalizada com sucesso").metadata(JOB_TYPE, (Object)VALIDACAO_ENDERECO).metadata(ID_COMUNICADO, (Object)idComunicado);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("N\u00e3o foi poss\u00edvel validar os endere\u00e7os.").title("Erro na valida\u00e7\u00e3o de endere\u00e7os").metadata(JOB_TYPE, (Object)VALIDACAO_ENDERECO).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public ValidacaoEnderecoJobListener(ComunicadoRepository comunicadoRepository, NotificacaoClient notificacaoClient) {
        this.comunicadoRepository = comunicadoRepository;
        this.notificacaoClient = notificacaoClient;
    }
}

