/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.validacaoendereco;

import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ValidacaoEnderecoBatchReader
extends JdbcPagingItemReader<Long> {
    public ValidacaoEnderecoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(1000);
        this.setName("notificacoesAValidarEndereco");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("sequencia"));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        String entidade = String.valueOf(jobParameters.get("entidade"));
        String exercicio = String.valueOf(jobParameters.get("exercicio"));
        String idComunicado = String.valueOf(jobParameters.get("idComunicado"));
        String sql = "WHERE a.Entidade = :Entidade AND a.Exercicio = :Exercicio AND a.IDComunicado = :IDComunicado AND (a.situacao NOT IN (:Impresso,:Cancelado) OR (a.situacao IS NULL)) ";
        sql = sql.replace(":Entidade", entidade);
        sql = sql.replace(":Exercicio", exercicio);
        sql = sql.replace(":IDComunicado", idComunicado);
        sql = sql.replace(":Impresso", String.valueOf(SituacaoComunicadoCadastro.IMPRESSO.getCodigo()));
        sql = sql.replace(":Cancelado", String.valueOf(SituacaoComunicadoCadastro.CANCELADO.getCodigo()));
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT sequencia ");
        provider.setFromClause("FROM TribComunicadoCadastro a ");
        provider.setWhereClause(sql);
        provider.setSortKey("sequencia");
        return provider;
    }
}

