/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.validacaoendereco;

import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.ComunicadoCadastroDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.repository.PessoaRepository;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ValidacaoEnderecoBatchProcessor
implements ItemProcessor<Long, ComunicadoCadastroDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidacaoEnderecoBatchProcessor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidacaoEnderecoBatchProcessor.class);
    private static final String LOG_PARAM = "COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os - ";
    private Long entidade;
    private Long exercicio;
    private Long idComunicado;
    private StepExecution stepExecution;
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final PessoaRepository pessoaRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os - Iniciando gera\u00e7\u00e3o de dados");
        this.entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        this.exercicio = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("exercicio"));
        this.idComunicado = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado"));
    }

    public ComunicadoCadastroDTO process(Long sequencia) throws Exception {
        String descricaoSituacao;
        SituacaoComunicadoCadastro situacao;
        Pessoa pessoa = this.pessoaRepository.findPessoaByComunicadoCadastro(this.entidade, this.exercicio, this.idComunicado, sequencia);
        if (Objects.isNull(pessoa)) {
            situacao = SituacaoComunicadoCadastro.PROBLEMA_NO_ENDERECO;
            descricaoSituacao = "Pessoa n\u00e3o encontrada para essa notifica\u00e7\u00e3o";
        } else {
            List inconsistencias = ComunicadoCadastro.getInconsistencias((Pessoa)pessoa);
            situacao = SituacaoComunicadoCadastro.validateEnderecoPorInconsistencia((List)inconsistencias);
            descricaoSituacao = inconsistencias.isEmpty() ? "Endere\u00e7o validado com sucesso!" : "Problema End.: " + String.join((CharSequence)", ", inconsistencias);
        }
        this.comunicadoCadastroRepository.updateSituacaoNotificacao(this.entidade, this.exercicio, this.idComunicado, sequencia, situacao, descricaoSituacao);
        ComunicadoCadastroDTO comunicadoCadastroDTO = new ComunicadoCadastroDTO();
        comunicadoCadastroDTO.setSequencia(sequencia);
        comunicadoCadastroDTO.setSituacao(situacao);
        comunicadoCadastroDTO.setDescricaoSituacao(descricaoSituacao);
        return comunicadoCadastroDTO;
    }

    public void onProcessError(Comunicado comunicado, Exception e) throws Exception {
        LOGGER.error("COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os - Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)comunicado));
        throw e;
    }

    @Generated
    public ValidacaoEnderecoBatchProcessor(ComunicadoCadastroRepository comunicadoCadastroRepository, PessoaRepository pessoaRepository) {
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.pessoaRepository = pessoaRepository;
    }
}

