/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class SimulacaoLoteCdaJobListener
extends JobExecutionListenerSupport {
    private static final String DATA = "data";
    private static final String JOB_TYPE = "jobType";
    private static final String ID_LOTE = "idLote";
    private static final String SIMULACAO_LOTE_CDA = JobType.SIMULACAO_LOTE_CDA.getTipo();
    private final NotificacaoClient notificacaoClient;
    private final LoteCdaRepository loteCdaRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
        LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        lote.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        this.loteCdaRepository.save((Object)lote);
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        Notificacao notificacao = Notificacao.builder().title(String.format("CDA - Iniciada a simula\u00e7\u00e3o do lote %d", idLote)).text(String.format("Iniciada a gera\u00e7\u00e3o de dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString())).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)SIMULACAO_LOTE_CDA).metadata(ID_LOTE, (Object)idLote).metadata(DATA, (Object)data).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        this.onHavingFailedSteps(jobExecution);
        this.onCompleted(jobExecution, notificacao, data);
        this.onFailed(jobExecution, notificacao, data);
    }

    private void onHavingFailedSteps(JobExecution jobExecution) {
        jobExecution.getStepExecutions().stream().filter(stepExecution -> BatchStatus.FAILED.equals((Object)stepExecution.getStatus())).forEach(stepExecution -> {
            jobExecution.setStatus(stepExecution.getStatus());
            jobExecution.setExitStatus(stepExecution.getExitStatus());
            stepExecution.getFailureExceptions().forEach(arg_0 -> ((JobExecution)jobExecution).addFailureException(arg_0));
        });
    }

    private void onCompleted(JobExecution jobExecution, Notificacao.Builder notificacao, LocalDate data) {
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
            LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
            lote.setSituacao(SituacaoLoteCda.SIMULACAO_GERADA);
            this.loteCdaRepository.save((Object)lote);
            notificacao.title(String.format("CDA - Simula\u00e7\u00e3o do lote %d finalizada com sucesso", idLote)).text(String.format("Os dados referentes \u00e0 simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa do dia %s foram gerados com sucesso.", data.toString())).metadata(JOB_TYPE, (Object)SIMULACAO_LOTE_CDA).metadata(ID_LOTE, (Object)idLote).metadata(DATA, (Object)data);
            this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
        }
    }

    private void onFailed(JobExecution jobExecution, Notificacao.Builder notificacao, LocalDate data) {
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
            LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
            lote.setSituacao(SituacaoLoteCda.ERRO_SIMULACAO);
            this.loteCdaRepository.save((Object)lote);
            notificacao.title(String.format("CDA - Erro na simula\u00e7\u00e3o do lote %d", idLote)).text("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)SIMULACAO_LOTE_CDA).metadata(ID_LOTE, (Object)idLote).metadata(DATA, (Object)data).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
            this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
        }
    }

    @Generated
    public SimulacaoLoteCdaJobListener(NotificacaoClient notificacaoClient, LoteCdaRepository loteCdaRepository) {
        this.notificacaoClient = notificacaoClient;
        this.loteCdaRepository = loteCdaRepository;
    }
}

