/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class FiltroValorMinimoCdaBatchWriter
implements ItemWriter<LoteCdaItem> {
    private static final String ID_LOTE = "idLote";
    private final LoteCdaItemRepository loteCdaItemRepository;
    private final LoteCdaService loteCdaService;
    private final AtomicLong sequencia = new AtomicLong(0L);
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.sequencia.set(stepExecution.getExecutionContext().getLong("sequencia", 0L));
    }

    public void write(List<? extends LoteCdaItem> items) {
        items.forEach(item -> {
            if (!item.getSequencia().equals(this.sequencia.get())) {
                item.setSequencia(Long.valueOf(this.sequencia.incrementAndGet()));
                this.loteCdaItemRepository.save(item);
            }
        });
        this.stepExecution.getExecutionContext().putLong("sequencia", this.sequencia.get());
    }

    @AfterStep
    public void afterStep() {
        try {
            if (this.loteCdaService.isCdasEmpty(this.stepExecution.getJobParameters().getLong(ID_LOTE))) {
                throw new EloValidationException("N\u00e3o foi encontrado nenhuma CDA com valor maior ou igual ao valor m\u00ednimo configurado.");
            }
        }
        catch (Exception e) {
            this.stepExecution.setStatus(BatchStatus.FAILED);
            this.stepExecution.setExitStatus(new ExitStatus(ExitStatus.FAILED.getExitCode(), e.getMessage()));
            this.stepExecution.addFailureException((Throwable)e);
        }
    }

    @Generated
    public FiltroValorMinimoCdaBatchWriter(LoteCdaItemRepository loteCdaItemRepository, LoteCdaService loteCdaService) {
        this.loteCdaItemRepository = loteCdaItemRepository;
        this.loteCdaService = loteCdaService;
    }
}

