/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class FiltroValorMinimoCdaBatchProcessor
implements ItemProcessor<Long, LoteCdaItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FiltroValorMinimoCdaBatchProcessor.class);
    private static final String GERACAO_LOTE_CDA_DTO = "geracaoLoteCdaDto";
    private static final String ID_LOTE = "idLote";
    private final LoteCdaItemRepository loteCdaItemRepository;
    private final ObjectMapper objectMapper;
    private BigDecimal valorMinimoCertidao;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        this.valorMinimoCertidao = ((GeracaoLoteCdaDTO)this.objectMapper.readValue(stepExecution.getJobParameters().getString(GERACAO_LOTE_CDA_DTO), GeracaoLoteCdaDTO.class)).getValorMinimoCertidao();
        log.info("Filtrando CDA's por valor m\u00ednimo - IdLote: {}, JobExecutionId: {}, ValorMinimoCertidao: {}.", new Object[]{stepExecution.getJobParameters().getLong(ID_LOTE), stepExecution.getJobExecution().getId(), this.valorMinimoCertidao});
    }

    public LoteCdaItem process(Long id) throws Exception {
        LoteCdaItem item = (LoteCdaItem)this.loteCdaItemRepository.findOne((Object)id);
        log.info("Processando LoteCdaItem - LoteCdaItem.Id: {}.", (Object)item.getId());
        if (item.calculateValorTotal().compareTo(this.valorMinimoCertidao) < 0) {
            log.info("Removendo LoteCdaItem - LoteCdaItem.Id: {}.", (Object)item.getId());
            this.loteCdaItemRepository.deleteById((Object)item.getId());
            this.loteCdaItemRepository.flush();
            return null;
        }
        return item;
    }

    @OnProcessError
    public void onProcessError(Long id, Exception e) {
        log.error("CDA - Filtro Valor M\u00ednimo de CDA - erro: {}\nLoteCdaItem.id: {})", (Object)e.getMessage(), (Object)id);
    }

    @Generated
    public FiltroValorMinimoCdaBatchProcessor(LoteCdaItemRepository loteCdaItemRepository, ObjectMapper objectMapper) {
        this.loteCdaItemRepository = loteCdaItemRepository;
        this.objectMapper = objectMapper;
    }
}

