/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoloteimpressaogeracaocarne;

import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressaoItem;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class CalculoGeracaoCarneBatchProcessor
implements ItemProcessor<Long, CalculoLoteImpressaoItemDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoGeracaoCarneBatchProcessor.class);
    private StepExecution stepExecution;
    private CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;

    public CalculoGeracaoCarneBatchProcessor(CalculoLoteImpressaoItemService calculoLoteImpressaoItemService) {
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public CalculoLoteImpressaoItemDTO process(Long calculoLoteImpressaoItemId) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.calculoLoteImpressaoItemService.findItemById(calculoLoteImpressaoItemId);
        if (Objects.nonNull(calculoLoteImpressaoItem.getCalculoCadastro().getEntidadeCarne()) && Objects.nonNull(calculoLoteImpressaoItem.getCalculoCadastro().getExercicioCarne()) && Objects.nonNull(calculoLoteImpressaoItem.getCalculoCadastro().getNumeroCarne())) {
            return null;
        }
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Executando a gera\u00e7\u00e3o do carn\u00ea do item do lote de impress\u00e3o com id {}", (Object)calculoLoteImpressaoItemId);
        return this.calculoLoteImpressaoItemService.gerarCarneBatch(calculoLoteImpressaoItemId);
    }
}

