/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoalteracaovencimentoparcela;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class CalculoAlteracaoVencimentoParcelaJobListener
extends JobExecutionListenerSupport {
    private static final String ID = "idCalculo";
    private static final String JOB_TYPE = "jobType";
    private static final String CALCULO_ALTERACAO_VENCIMENTO_PARCELA = JobType.CALCULO_ALTERACAO_VENCIMENTO_PARCELA.getTipo();
    private final NotificacaoClient notificacaoClient;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        Notificacao notificacao = Notificacao.builder().text("Altera\u00e7\u00e3o do vencimento dos carn\u00eas iniciada.").title(String.format("Foi iniciada a altera\u00e7\u00e3o do vencimento por parcela dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)CALCULO_ALTERACAO_VENCIMENTO_PARCELA).metadata(ID, (Object)idCalculo).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Altera\u00e7\u00e3o do vencimento dos carn\u00eas finalizada com sucesso.").title(String.format("A altera\u00e7\u00e3o do vencimento dos carn\u00eas por parcela dos lotes de impress\u00e3o do c\u00e1lculo %d foi finalizada com sucesso.", idCalculo)).metadata(JOB_TYPE, (Object)CALCULO_ALTERACAO_VENCIMENTO_PARCELA).metadata(ID, (Object)idCalculo);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na altera\u00e7\u00e3o do vencimento dos carn\u00eas.").title(String.format("N\u00e3o foi poss\u00edvel realizar a altera\u00e7\u00e3o do vencimento dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo)).metadata(JOB_TYPE, (Object)CALCULO_ALTERACAO_VENCIMENTO_PARCELA).metadata(ID, (Object)idCalculo).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public CalculoAlteracaoVencimentoParcelaJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }
}

