/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoalteracaovencimentoparcela;

import br.com.elotech.tributos.calculo.dto.AlteracaoVencimentoParcelaDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class CalculoAlteracaoVencimentoParcelaBatchProcessor
implements ItemProcessor<Long, CalculoLoteImpressaoItemDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoAlteracaoVencimentoParcelaBatchProcessor.class);
    private StepExecution stepExecution;
    private CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;
    private ObjectMapper objectMapper;

    public CalculoAlteracaoVencimentoParcelaBatchProcessor(CalculoLoteImpressaoItemService calculoLoteImpressaoItemService, ObjectMapper objectMapper) {
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public CalculoLoteImpressaoItemDTO process(Long calculoLoteImpressaoItemId) throws JsonProcessingException {
        CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, AlteracaoVencimentoParcelaDTO.class);
        List parcelas = Objects.requireNonNull((List)this.objectMapper.readValue(this.stepExecution.getJobExecution().getJobParameters().getString("parcelasJson"), (JavaType)type));
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Executando a altera\u00e7\u00e3o do item do lote de impress\u00e3o com id {}", (Object)calculoLoteImpressaoItemId);
        this.calculoLoteImpressaoItemService.alterarVencimentoParcelas(calculoLoteImpressaoItemId, parcelas, this.stepExecution);
        return null;
    }
}

