/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.Serializable;
import java.util.Date;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class BaixaAutomaticaJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String LOTE = "lote";
    private static final String ENTIDADE = "entidade";
    private static final String JOB_TYPE = "jobType";
    private static final String BAIXA_AUTOMATICA = JobType.BAIXA_AUTOMATICA.getTipo();
    private final NotificacaoClient notificacaoClient;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public BaixaAutomaticaJobListener(NotificacaoClient notificacaoClient, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.notificacaoClient = notificacaoClient;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = jobExecution.getJobParameters().getLong(ENTIDADE);
        Long exercicio = jobExecution.getJobParameters().getLong(EXERCICIO);
        Long lote = jobExecution.getJobParameters().getLong(LOTE);
        PagamentoLoteId pagamentoLoteId = new PagamentoLoteId();
        pagamentoLoteId.setEntidade(entidade);
        pagamentoLoteId.setExercicio(exercicio);
        pagamentoLoteId.setLote(lote);
        PagamentoLote pagamentoLote = (PagamentoLote)this.pagamentoLoteService.findOne((Serializable)pagamentoLoteId);
        this.validaDataMovimentacaoService.validaMesEDia(entidade, pagamentoLote.getDataMovimento());
        pagamentoLote.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
        Notificacao notificacao = Notificacao.builder().text("Baixa de Pagamento iniciada").title(String.format("Foi iniciada a baixa do lote de pagamento %d/%d", lote, exercicio)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)BAIXA_AUTOMATICA).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(LOTE, (Object)lote).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        Long lote = jobExecution.getJobParameters().getLong(LOTE);
        Long exercicio = jobExecution.getJobParameters().getLong(EXERCICIO);
        Long entidade = jobExecution.getJobParameters().getLong(ENTIDADE);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Baixa de pagamentos finalizada com sucesso").title(String.format("A baixa do lote %d/%d foi finalizada com sucesso.", lote, exercicio)).metadata(JOB_TYPE, (Object)BAIXA_AUTOMATICA).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(LOTE, (Object)lote);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na baixa de pagamentos").title("N\u00e3o foi poss\u00edvel realizar a baixa de pagamentos.").metadata(JOB_TYPE, (Object)BAIXA_AUTOMATICA).metadata(ENTIDADE, (Object)entidade).metadata(EXERCICIO, (Object)exercicio).metadata(LOTE, (Object)lote).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

