/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.listener.ItemListenerSupport;

public class DefaultItemFailureListener
extends ItemListenerSupport<Object, Object> {
    protected static final Log logger = LogFactory.getLog(DefaultItemFailureListener.class);
    private static final String INVALID_TYPE_FOR_LOGGING = "Invalid type for logging: [%s]";

    public void onReadError(Exception ex) {
        try {
            logger.error((Object)"Error encountered while reading", (Throwable)ex);
        }
        catch (Exception exception) {
            logger.error((Object)String.format(INVALID_TYPE_FOR_LOGGING, ex.toString()));
        }
    }

    public void onProcessError(Object item, Exception ex) {
        try {
            logger.error((Object)"Error encountered while processing", (Throwable)ex);
        }
        catch (Exception exception) {
            logger.error((Object)String.format(INVALID_TYPE_FOR_LOGGING, ex.toString()));
        }
    }

    public void onWriteError(Exception ex, List<? extends Object> item) {
        try {
            logger.error((Object)("Error encountered while writing item: [ " + item + "]"), (Throwable)ex);
        }
        catch (Exception exception) {
            logger.error((Object)String.format(INVALID_TYPE_FOR_LOGGING, ex.toString()));
        }
    }
}

