/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.audit;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.audit.reader.RevisionReader;
import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.metamodel.loader.MetaModelLoader;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.tributos.audit.TributosRevision;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditService.class);
    private final RevisionReader revisionReader;

    public AuditService(RevisionReader revisionReader) {
        this.revisionReader = revisionReader;
    }

    public <S extends Serializable, T> Page<ChangeWithRevision> getRevisionForEntity(Class<T> entityClass, S entityId, String search, Pageable pageable) {
        List filtroCampos = RsqlUtils.getFieldValues((String)search, (String)"fieldName");
        String searchWithoutFieldName = RsqlUtils.removeField((String)search, (String)"fieldName");
        List history = this.revisionReader.findHistory(entityClass, TributosRevision.class, entityId, searchWithoutFieldName);
        List flatRevision = this.revisionReader.flattenChanges(history);
        MetaModel metaModel = MetaModelLoader.newMetaModel(entityClass, (boolean)true);
        List historyWithCaptions = flatRevision.stream().map(historyEntry -> {
            String fieldPath = historyEntry.getChange().getField();
            try {
                String caption = metaModel.getCaption(fieldPath);
                historyEntry.getChange().setField(caption);
            }
            catch (IllegalArgumentException ex) {
                log.warn(String.format("Campo %s n\u00e3o encontrado na classe %s", fieldPath, entityClass.getName()));
            }
            return historyEntry;
        }).collect(Collectors.toList());
        List filteredHistory = this.filtrarPorCampoModificado(filtroCampos, historyWithCaptions);
        List pagedHistory = filteredHistory.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(pagedHistory, pageable, (long)filteredHistory.size());
    }

    private List<ChangeWithRevision> filtrarPorCampoModificado(List<AttributeGetterResult> filtroCampos, List<ChangeWithRevision> history) {
        if (filtroCampos.isEmpty()) {
            return history;
        }
        return history.stream().filter(change -> this.filtrarCampoModificado(change, filtroCampos)).collect(Collectors.toList());
    }

    public <T, S extends Serializable> T getRecordAtDate(Class<T> entityClass, S entityId, LocalDateTime referenceDate) {
        return (T)this.revisionReader.getRecordAtDate(entityClass, entityId, DateUtils.localDateTimeToDate((LocalDateTime)referenceDate));
    }

    private Boolean filtrarCampoModificado(ChangeWithRevision change, List<AttributeGetterResult> filtroCampos) {
        return filtroCampos.stream().anyMatch(fieldFilter -> {
            if (fieldFilter.getOperator().equals("==")) {
                if (fieldFilter.getValue().startsWith("*") && fieldFilter.getValue().endsWith("*")) {
                    return change.getChange().getField().toLowerCase().contains(fieldFilter.getValue().substring(1, fieldFilter.getValue().length() - 1).toLowerCase());
                }
                return change.getChange().getField().equalsIgnoreCase(fieldFilter.getValue());
            }
            return !change.getChange().getField().equalsIgnoreCase(fieldFilter.getValue());
        });
    }
}

