SELECT :idPessoa as idPessoa,
       filtro.nrAnoEstorno,
       filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.cdControleLeiAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo
FROM (/*Cancelamento*/ SELECT extract(YEAR FROM tcdi.dataestorno) AS nrAnoEstorno,
                              ca.idtce                       AS cdControleLeiAto,
                              tc.nrdeducao                   AS nrDeducao,
                              tc.nranodeducao                AS nrAnoDeducao,
                              tcdi.dataestorno               AS dtEstorno,
                              tcdi.valor                     AS vlEstorno,
                              substr(cd.motivo, 0, 250)      AS dsMotivo
                       FROM tribcancelamentodebito cd
                                INNER JOIN tribcancelamentodebitoitem tcdi
                                           ON tcdi.entidade = cd.entidade AND
                                              tcdi.exercicio = cd.exercicio AND
                                              tcdi.idcancelamento = cd.idcancelamento
                                INNER JOIN tceDeducaoCancelamentoDA tdc
                                           ON tdc.entidade = tcdi.entidade AND
                                              tdc.exercicio = tcdi.exercicio AND
                                              tdc.idcancelamento = tcdi.idcancelamento AND
                                              tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                                INNER JOIN tceDeducaoCreditoDA tc
                                           ON tc.idtcededucaocreditoDA = tdc.idtcededucaocreditoDA
                                LEFT JOIN tribmotivodesconto md ON md.motivodesconto = cd.motivocancelamento
                                LEFT JOIN cgato ca ON ca.entidade = md.entidade
                           AND ca.idato = md.idato
                       WHERE (tcdi.dataestorno BETWEEN :dataInicial AND :dataFinal)
                         AND cd.entidade = :entidade
                         AND tcdi.estornado = 'S'
                       UNION ALL
                       /*pagamento*/
                       SELECT extract(YEAR FROM tep.data)       AS nrAnoEstorno,
                              ca.idtce                     AS cdControleLeiAto,
                              tc.nrdeducao                 AS nrDeducao,
                              tc.nranodeducao              AS nrAnoDeducao,
                              tep.data                     AS dtEstorno,
                              tpd.valordesconto            AS vlEstorno,
                              substr(md.descricao, 0, 250) AS dsMotivo
                       FROM tribpagamentodebito tpd
                                INNER JOIN tribEstornoPagamentoItem tepi
                                           ON tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto AND
                                              tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                                INNER JOIN tribestornopagamento tep ON tep.entidade = tepi.entidade AND
                                                                       tep.exercicio = tepi.exercicio AND
                                                                       tep.estorno = tepi.estorno
                                INNER JOIN tcededucaopagamentoDA tdp
                                           ON tpd.idpagamentobloqueto = tpd.idpagamentobloqueto AND
                                              tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                                INNER JOIN tceDeducaoCreditoDA tc
                                           ON tc.idtcededucaocreditoDA = tdp.idtcededucaocreditoDA
                                LEFT JOIN tribmotivodesconto md ON md.motivodesconto = tep.motivodesconto
                                LEFT JOIN cgato ca ON ca.entidade = md.entidade AND
                                                      ca.idato = md.idato
                       WHERE tep.data BETWEEN :dataInicial AND :dataFinal
                         AND tep.entidade = :entidade
                       UNION ALL
                       /*Credito*/
                       SELECT extract(YEAR FROM tcc.dataestorno)         AS nrAnoEstorno,
                              ca.idtce                              AS cdControleLeiAto,
                              tc.nrdeducao                          AS nrDeducao,
                              tc.nranodeducao                       AS nrAnoDeducao,
                              tcc.dataestorno                       AS dtEstorno,
                              tcci.valordesconto                    AS vlEstorno,
                              substr(tcc.observacaoestorno, 0, 250) AS dsMotivo
                       FROM tribcreditocontribuinte tcc
                                INNER JOIN tribcreditocontribuinteitem tcci ON tcci.entidade = tcc.entidade AND
                                                                               tcci.exercicio = tcc.exercicio AND
                                                                               tcci.creditocontribuinte = tcc.creditocontribuinte
                                INNER JOIN tceDeducaoCreditoCreditoDA tdcc
                                           ON tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem AND
                                              tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
                                INNER JOIN tceDeducaoCreditoDA tc
                                           ON tc.idtcededucaocreditoDA = tdcc.idtcededucaocreditoDA
                                LEFT JOIN tribmotivodesconto md ON md.motivodesconto = tcc.motivodescontoestorno
                                LEFT JOIN cgato ca ON ca.entidade = md.entidade AND
                                                      ca.idato = md.idato
                       WHERE tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
                         AND tcc.entidade = :entidade
                         AND tcc.valorestornado > 0
                         AND tcci.valordesconto > 0) filtro
ORDER BY filtro.dtEstorno,
         filtro.nrAnoDeducao,
         filtro.nrDeducao