select :idPessoa as idPessoa,
       filtro.nrAnoEstorno,
       filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.cdControleLeiAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo
from (
         /*Cancelamento*/
         select extract(year from tcdi.dataestorno) as nrAnoEstorno,
                ca.idtce                            as cdControleLeiAto,
                tc.nrdeducao                        as nrDeducao,
                tc.nranodeducao                     as nrAnoDeducao,
                tcdi.dataestorno                    as dtEstorno,
                tcdi.valor                          as vlEstorno,
                substr(cd.motivo, 0, 250)           as dsMotivo
         from tribcancelamentodebito cd
                  inner join tribcancelamentodebitoitem tcdi
                             on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and
                                tcdi.idcancelamento = cd.idcancelamento
                  inner join tceDeducaoCancelamento tdc
                             on tdc.entidade = tcdi.entidade and tdc.exercicio = tcdi.exercicio and
                                tdc.idcancelamento = tcdi.idcancelamento and
                                tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                  inner join tceDeducaoCredito tc on tc.idtcededucaocredito = tdc.idtcededucaocredito
                  left join tribmotivodesconto md on md.motivodesconto = cd.motivocancelamento
                  left join cgato ca on ca.entidade = md.entidade and
                                        ca.idato = md.idato
         where (tcdi.dataestorno between :dataInicial and :dataFinal)
           and cd.entidade = :entidade
           and tcdi.estornado = 'S'
         union all
         /*pagamento*/
         select extract(year from tep.data)  as nrAnoEstorno,
                ca.idtce                     as cdControleLeiAto,
                tc.nrdeducao                 as nrDeducao,
                tc.nranodeducao              as nrAnoDeducao,
                tep.data                     as dtEstorno,
                tpd.valordesconto            as vlEstorno,
                substr(md.descricao, 0, 250) as dsMotivo
         from tribpagamentodebito tpd
                  inner join tribEstornoPagamentoItem tepi
                             on tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto and
                                tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                  inner join tribestornopagamento tep
                             on tep.entidade = tepi.entidade and
                                tep.exercicio = tepi.exercicio and
                                tep.estorno = tepi.estorno
                  inner join tcededucaopagamento tdp
                             on tpd.idpagamentobloqueto = tpd.idpagamentobloqueto and
                                tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                  inner join tceDeducaoCredito tc on tc.idtcededucaocredito = tdp.idtcededucaocredito
                  left join tribmotivodesconto md on md.motivodesconto = tep.motivodesconto
                  left join cgato ca
                            on ca.entidade = md.entidade and
                               ca.idato = md.idato
         where tep.data between :dataInicial and :dataFinal
           and tep.entidade = :entidade
         union all
         /*Credito*/
         select extract(year from tcc.dataestorno)    as nrAnoEstorno,
                ca.idtce                              as cdControleLeiAto,
                tc.nrdeducao                          as nrDeducao,
                tc.nranodeducao                       as nrAnoDeducao,
                tcc.dataestorno                       as dtEstorno,
                tcci.valordesconto                    as vlEstorno,
                substr(tcc.observacaoestorno, 0, 250) as dsMotivo
         from tribcreditocontribuinte tcc
                  inner join tribcreditocontribuinteitem tcci
                             on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                                tcci.creditocontribuinte = tcc.creditocontribuinte
                  inner join tceDeducaoCreditoCredito tdcc
                             on tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem and
                                tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
                  inner join tceDeducaoCredito tc on tc.idtcededucaocredito = tdcc.idtcededucaocredito
                  left join tribmotivodesconto md on md.motivodesconto = tcc.motivodescontoestorno
                  left join cgato ca on ca.entidade = md.entidade and
                                        ca.idato = md.idato
         where tcc.dataestorno between :dataInicial and :dataFinal
           and tcc.entidade = :entidade
           and tcc.valorestornado > 0
           and tcci.valordesconto > 0
     ) filtro
order by filtro.dtEstorno, filtro.nrAnoDeducao, filtro.nrDeducao;