select
    :idPessoa as idPessoa, 
    filtro.nrAnoEstorno, 
    filtro.nrAtualizacao,
    filtro.nrAnoAtualizacao,
    filtro.cdControleLeiAto,
    filtro.dtEstorno,
    filtro.vlEstorno,
    filtro.dsMotivo
from 
( 
   select extract(year from tep.data) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tep.data) as nrMes, 
          extract(year  from tep.data) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tep.data as dtEstorno, 
          tpd.valorjuros as vlEstorno, 
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo 
   FROM tribestornopagamento             tep 
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno 
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMonePagamento    tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMoneCred         tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred 
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto 
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato 
   WHERE tep.entidade = :entidade 
     and tep.data BETWEEN :dataInicial AND :dataFinal 
     and tep.geracreditocontribuinte = 'N' 
     and tpd.estorno = 'S' 
     and tpd.valorjuros > 0 
     and tamc.idtipoatualizacaocredito = 1 
   union all 
   select extract(year from tep.data) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tep.data) as nrMes, 
          extract(year  from tep.data) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tep.data as dtEstorno, 
          tpd.valormulta as vlEstorno, 
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo 
   FROM tribestornopagamento             tep 
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno 
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMonePagamento    tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMoneCred         tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred 
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto 
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato 
   WHERE tep.entidade = :entidade 
     and tep.data BETWEEN :dataInicial AND :dataFinal 
     and tep.geracreditocontribuinte = 'N' 
     and tpd.estorno = 'S' 
     and tpd.valormulta > 0 
     and tamc.idtipoatualizacaocredito = 2 
   union all 
   select extract(year from tep.data) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tep.data) as nrMes, 
          extract(year  from tep.data) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tep.data as dtEstorno, 
          tpd.valorcorrecao as vlEstorno, 
          substr(tmd.descricao || '. ' || tep.motivoestorno, 0, 250) as dsMotivo 
   FROM tribestornopagamento             tep 
        join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno 
        join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMonePagamento    tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita 
        join tceAtualizaMoneCred         tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred 
   left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto 
   left join cgato                       ca   on ca.entidade = tep.entidade and ca.idato = tmd.idato 
   WHERE tep.entidade = :entidade 
     and tep.data BETWEEN :dataInicial AND :dataFinal 
     and tep.geracreditocontribuinte = 'N' 
     and tpd.estorno = 'S' 
     and tpd.valorcorrecao > 0 
     and tamc.idtipoatualizacaocredito = 3 
   union all 
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tcc.dataestorno) as nrMes, 
          extract(year  from tcc.dataestorno) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tcc.dataestorno as dtEstorno, 
          tcci.valorjuros as vlEstorno, 
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo 
   FROM tribcreditocontribuinte           tcc 
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
        join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
        join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred 
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno 
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato 
   WHERE tcc.entidade = :entidade 
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal 
     and tcci.valorjuros > 0 
     and tamc.idtipoatualizacaocredito = 1 
   union all 
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tcc.dataestorno) as nrMes, 
          extract(year  from tcc.dataestorno) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tcc.dataestorno as dtEstorno, 
          tcci.valormulta as vlEstorno, 
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo 
   FROM tribcreditocontribuinte           tcc 
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
        join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
        join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred 
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno 
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato 
   WHERE tcc.entidade = :entidade 
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal 
     and tcci.valormulta > 0 
     and tamc.idtipoatualizacaocredito = 2 
   union all 
   SELECT extract(year from tcc.dataestorno) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tcc.dataestorno) as nrMes, 
          extract(year  from tcc.dataestorno) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tcc.dataestorno as dtEstorno, 
          tcci.valorcorrecao as vlEstorno, 
          substr(tmd.descricao  || '. ' || tcc.observacaoestorno, 0, 250) as dsMotivo 
   FROM tribcreditocontribuinte           tcc 
        join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
        join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
        join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred 
   left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno 
   left join cgato                        ca    on ca.entidade = tcc.entidade and ca.idato = tmd.idato 
   WHERE tcc.entidade = :entidade 
     and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal 
     and tcci.valorcorrecao > 0 
     and tamc.idtipoatualizacaocredito = 3 
   union all 
   select distinct 
          extract(year from tep.dataestorno) as nrAnoEstorno, 
          tamc.nrAtualizacao, 
          tamc.nrAnoAtualizacao, 
          extract(month from tep.dataestorno) as nrMes, 
          extract(year  from tep.dataestorno) as nrAno, 
          ca.idtce as cdControleLeiAto, 
          tep.dataestorno as dtEstorno, 
          tdpr.valor as vlEstorno, 
          substr(tmd.descricao || '. ' || tep.motivo, 0, 250) as dsMotivo 
   from tribestornoparcelamento            tep 
        join tribparcelamento              tpar  on tpar.idparcelamento = tep.idparcelamento 
        join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tpar.idparcelamento 
        join tribestparcelamparcrecdestino tepd  on tepd.iddebitoparcelareceita = tppro.iddebitoparcelareceita and tepd.idestornoparcelamento = tep.idestornoparcelamento 
        join tceAtualizaMoneParc           tamp  on tamp.idparcelamento = tppro.idparcelamento and tamp.iddebitoparcelareceita = tppro.iddebitoparcelareceita 
        join tceAtualizaMoneCred           tamc  on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred 
        join tribparcelamentodebitoorigem  tpdo  on tpdo.idparcelamento = tep.idparcelamento 
        join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
        join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio 
                                                and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral 
                                                and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
        join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                                and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                                and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                                and tdpr.parcela = tdp.parcela 
        join tribreceita                   tr    on tr.entidade  = tdpr.entidade  and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita 
   left join tribparamparcelamento         tpp   on tpp.idparametroparcelamento =  tpar.idparametroparcelamento 
   left join tribmotivodesconto            tmd   on tmd.motivodesconto = tpp.motivoestorno 
   left join cgato                         ca    on ca.entidade = tmd.entidade and ca.idato = tmd.idato 
   WHERE tdpr.entidade = :entidade 
     and tep.dataestorno BETWEEN :dataInicial AND :dataFinal 
     and tep.estornado = 'N' 
     and ((tr.classificacao = 'J' and tamc.idtipoatualizacaocredito = 1 ) or 
          (tr.classificacao = 'M' and tamc.idtipoatualizacaocredito = 2 ) or 
          (tr.classificacao = 'C' and tamc.idtipoatualizacaocredito = 3 ) ) 
) filtro 
order by filtro.nrAnoAtualizacao, filtro.nrAtualizacao
