select 02                                  as codigoArquivo,
       'Estorno de Lançamento de Créditos' as arquivo,
       'DEBITO'                            as tipoArquivo,
       sum(coalesce(arquivo.valor, 0))     as valorArquivo,
       sum(coalesce(integracao.valor, 0))  as valorIntegrado
from (select sum(coalesce(tcdi.valorAtualizado, tcdi.valor)) as valor
      from tribcancelamentodebito cd

               join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and
                                                       tcdi.exercicio = cd.exercicio and tcdi.
                                                                                             idcancelamento =
                                                                                         cd.idcancelamento
               left join tribmotivodesconto md
                         on md.motivodesconto = cd.motivocancelamento
               left join tribtipodeducao td on td.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
               left join tribdebitoparcelareceita tdpr on tcdi.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
               left join tribreceita r
                         on r.receita = tdpr.receita and r.exercicio = tdpr.exercicio and
                            r.entidade = tdpr.entidade
               JOIN tribreceitatipo trt
                    ON trt.tiporeceita = r.tiporeceita
      where cd.entidade = :entidade
        and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
        and cd.datacancelamento between :dataInicial and :dataFinal
        and td.tipotce = 8
     ) as arquivo
         cross join (select sum(iip.valor) as valor
                     from integracaopatrimonial ip
                              left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                              left join tribreceita r
                                        on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                           r.entidade = ip.entidade
                              JOIN tribreceitatipo trt
                                   ON trt.tiporeceita = r.tiporeceita
                     where ip.entidade = :entidade
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and ip.datamovimento between :dataInicial and :dataFinal
                       and iip.tipomovimento = 'CANCELAMENTO'
                       and iip.situacaolegal = 0
                       and iip.tipodeducao = 8
                       and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE') as integracao