select filtro.idTipoAtualizacaoCredito, 
       filtro.dtAtualizacao, 
       filtro.nrdivida, 
       filtro.nranodivida, 
       filtro.idpagamentobloqueto, 
       filtro.iddebitoparcelareceita, 
       filtro.idCreditoContribuinteItem, 
       filtro.vlAtualizacao,
       filtro.cdControleLeiAto
from ( 
  select distinct 1 as idTipoAtualizacaoCredito,
         tpd.valorjuros as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tp.datapagamento as dtAtualizacao, 
         tid.nrdivida, 
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribpagamento tp 
  join tribpagamentobloqueto       tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0 and tpd.situacaolegal in (1, 2) and tpd.valorpago > 0
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tpd.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  join tribguiarecolhimento        tgr  on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato                  ato  on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists (select 1 from tceAtualizaMonePagamentoDA tampDA
                    where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                    and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
  union all
  select distinct 2 as idTipoAtualizacaoCredito,
         tpd.valormulta as vlAtualizacao,
         tpd.idpagamentobloqueto,
         tpd.iddebitoparcelareceita,
         0 as idCreditoContribuinteItem,
         tp.datapagamento as dtAtualizacao,
         tid.nrdivida,
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribpagamento tp
  join tribpagamentobloqueto       tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0 and tpd.situacaolegal in (1, 2) and tpd.valorpago > 0
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tpd.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  join tribguiarecolhimento        tgr  on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato                  ato  on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists (select 1 from tceAtualizaMonePagamentoDA tampDA
                    where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                    and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
  union all 
  select distinct 3 as idTipoAtualizacaoCredito,
         tpd.valorcorrecao as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tp.datapagamento as dtAtualizacao, 
         tid.nrdivida, 
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribpagamento tp 
  join tribpagamentobloqueto       tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0 and tpd.situacaolegal in (1, 2) and tpd.valorpago > 0
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tpd.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  join tribguiarecolhimento         tgr on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tp.entidade = :entidade and tp.datapagamento between :dataInicial and :dataFinal
    and not exists (select 1 from tceAtualizaMonePagamentoDA tampDA
                    where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                    and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
  union all 
  select distinct 1 as idTipoAtualizacaoCredito,
         tcci.valorjuros as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tid.nrdivida, 
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tcci.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribguiarecolhimento         tgr on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato                   ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
    and tcci.valorjuros > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal in (1,2) 
    and not exists (select 1 from tceAtualizaMoneCreditoDA tamcDA
                    where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                    and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
  union all 
  select distinct 2 as idTipoAtualizacaoCredito,
         tcci.valormulta as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tid.nrdivida, 
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tcci.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribguiarecolhimento         tgr on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato                   ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
    and tcci.valormulta > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal in (1,2) 
    and not exists (select 1 from tceAtualizaMoneCreditoDA tamcDA
                    where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                    and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
  union all 
  select distinct 3 as idTipoAtualizacaoCredito,
         tcci.valorcorrecao as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         tcc.datacredito as dtAtualizacao, 
         tid.nrdivida, 
         tid.nranodivida,
         ato.idtce as cdControleLeiAto
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceitadestino = tcci.iddebitoparcelareceita
  left join tceinsccreditoda       tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
  join tribguiarecolhimento        tgr  on tdpr.entidade = tgr.entidade
                                       and tdpr.exercicio = tgr.exercicio
                                       and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join cgato                   ato on tgr.entidade = ato.entidade and tgr.fundamentolegal = ato.idato
  where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
    and tcci.valorcorrecao > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal in (1,2) 
    and not exists (select 1 from tceAtualizaMoneCreditoDA tamcDA
                    where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                    and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
) filtro 
order by filtro.dtAtualizacao, 
         filtro.nrdivida, 
         filtro.nranodivida, 
         filtro.idpagamentobloqueto, 
         filtro.iddebitoparcelareceita, 
         filtro.idTipoAtualizacaoCredito;