select case when (tr.classificacao = 'J' or tr.classificacao = 'F') then 1 
            when (tr.classificacao = 'M') then 2 else 3 end as idTipoAtualizacaoCredito, 
       tp.dataparcelamento as dtAtualizacao, 
       :receitaPrincipal as receitaPrincipal, 
       tr.receita, 
       tr.classificacao, 
       tp.idParcelamento, 
       sum(tdpr.valor) as vlAtualizacao 
from tribparcelamento              tp 
join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio  
                                        and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral  
                                        and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                        and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                        and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                        and tdpr.parcela = tdp.parcela 
join tribparcelamentoreceitaespelho tpre on tpre.idparcelamento = tp.idparcelamento 
                                        and tpre.iddebitonovo = td.iddebito 
                                        and (tpre.jurosdestino = tdpr.receita or tpre.multadestino = tdpr.receita or 
                                             tpre.correcaodestino = tdpr.receita or tpre.jurosfinandestino = tdpr.receita) 
left join tribreceita               tr   on tr.entidade =  :entidade
                                        and tr.exercicio  =  :exercicio
                                        and tr.receita = tdpr.receita 
where tp.idparcelamento = :idparcelamento 
  and tr.classificacao in ('J','M','C','F') 
  and tpre.receitaorigem = :receitaPrincipal 
group by tp.dataparcelamento, 
         tr.receita, 
         tr.classificacao, 
         tp.idparcelamento, 
         tpre.receitaorigem 
order by tp.idparcelamento, case when (tr.classificacao = 'J' or tr.classificacao = 'F') then 1 when (tr.classificacao = 'M') then 2 else 3 end 
