select filtro.entidade,
       filtro.exercicio,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.idTipoOrigemReceita,
       filtro.idTipoArrecadacao,
       filtro.iddebitoparcelareceita,
       filtro.vlArrecadacao,
       filtro.nrCredito,
       filtro.nrAnoCredito,
       filtro.nrDivida,
       filtro.nrAnoDivida,
       filtro.nrMes,
       filtro.nrAno
from
(
   SELECT tp.entidade,
          tp.exerciciopagamento AS exercicio,
          tpb.idpagamentobloqueto,
          0 as idcreditocontribuinteitem,
          CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
          1 AS idTipoArrecadacao,
          tpd.iddebitoparcelareceita,
          tpd.valorpago AS vlArrecadacao,
          case when (tpd.situacaolegal = 0) then tlc.nrcredito else null end as nrCredito,
          case when (tpd.situacaolegal = 0) then tlc.nranocredito else null end as nranocredito,
          case when (tpd.situacaolegal = 1) then tid.nrdivida else null end as nrdivida,
          case when (tpd.situacaolegal = 1) then tid.nranodivida else null end as nranodivida,
          extract(month from tp.datacredito) as nrMes,
          extract(year  from tp.datacredito) as nrAno
   FROM tribpagamento tp
   JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
   JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
   left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
   left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceitaDestino = tpd.iddebitoparcelareceita
   left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
   WHERE tp.entidade = :entidade
     AND tp.datacredito BETWEEN :dataInicial AND :dataFinal
     and tpd.valorpago > 0
     and not exists (select 1 from tcearrtipocreditopagamento atcp
                     where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                       and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
   union all
   SELECT tcc.entidade,
          tcc.exercicio,
          0 as idpagamentobloqueto,
          tcci.idcreditocontribuinteitem,
          CASE WHEN tdp.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
          1 AS idTipoArrecadacao,
          tcci.iddebitoparcelareceita,
          tcci.valorlancado AS valor,
          case when (tdp.situacaolegal = 0) then tlc.nrcredito else null end as nrCredito,
          case when (tdp.situacaolegal = 0) then tlc.nranocredito else null end as nranocredito,
          case when (tdp.situacaolegal = 1) then tid.nrdivida else null end as nrdivida,
          case when (tdp.situacaolegal = 1) then tid.nranodivida else null end as nranodivida,
          extract(month from tcc.datacredito) as nrMes,
          extract(year  from tcc.datacredito) as nrAno
   FROM tribcreditocontribuinte tcc
   JOIN tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
   left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
   left outer join tribdebitoparcela tdp on tdp.entidade  = tdpr.entidade
                 and tdp.exercicio = tdpr.exercicio
                 and tdp.tipocadastro = tdpr.tipocadastro
                 and tdp.cadastrogeral  = tdpr.cadastrogeral
                 and tdp.guiarecolhimento  = tdpr.guiarecolhimento
                 and tdp.subdivida  = tdpr.subdivida
                 and tdp.parcela = tdpr.parcela
   left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
   left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceitadestino from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceitaDestino = tcci.iddebitoparcelareceita
   left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
   WHERE tcc.entidade = :entidade
     AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
     and tcci.valorlancado > 0
     and not exists (select 1 from tceArrTipocreditoCredito atcc
                     where atcc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                       and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
) as filtro
ORDER by filtro.idTipoOrigemReceita