CREATE OR REPLACE VIEW ENDERECO AS SELECT PES.PESSOA,
      ENDE.TIPOENDERECO,
      ENDE.CEP,
      CID.DESCRICAO AS CIDADE,
      ENDE.CIDADE AS CODIGOCIDADE,
      ENDE.NUMERO,
      TIPOLOG.SIGLA AS TIPOLOGRADOURO,
      LOG.DESCRICAO AS LOGRADOURO,
      BAI.DESCRICAO AS BAIRRO,
      CID.UNIDADEFEDERACAO,
      ENDE.COMPLEMENTO,
      ENDE.SEQUENCIA,
      CASE WHEN TIPOLOG.SIGLA IS NOT NULL THEN TIPOLOG.SIGLA || ' ' END ||
      CASE WHEN LOG.DESCRICAO IS NOT NULL OR LOG.DESCRICAO <> '' THEN LOG.DESCRICAO || ', ' END ||
      CASE WHEN ENDE.NUMERO IS NOT NULL THEN ENDE.NUMERO || ', ' END ||
      CASE WHEN ENDE.COMPLEMENTO IS NOT NULL THEN ENDE.COMPLEMENTO  || ' - ' END ||
      CASE WHEN BAI.DESCRICAO IS NOT NULL THEN BAI.DESCRICAO || ' ' END ||
      CASE WHEN CID.DESCRICAO IS NOT NULL THEN CID.DESCRICAO || '-' || CID.UNIDADEFEDERACAO END ||
      CASE WHEN ENDE.CEP IS NOT NULL AND ENDE.CEP > 0 THEN ' CEP:' || ENDE.CEP || ' ' END
      AS ENDERECOCOMPLETO
FROM PESSOA PES
LEFT OUTER JOIN ENDERECOPESSOA ENDE ON
    PES.PESSOA = ENDE.PESSOA
    AND PES.SEQUENCIAENDERECO = ENDE.SEQUENCIA
LEFT OUTER JOIN CIDADE CID ON
    ENDE.CIDADE = CID.CIDADE
LEFT OUTER JOIN LOGRADOURO LOG ON
    ENDE.CIDADE = LOG.CIDADE
    AND ENDE.LOGRADOURO = LOG.LOGRADOURO
LEFT OUTER JOIN BAIRRO BAI ON
    ENDE.CIDADE = BAI.CIDADE
    AND ENDE.BAIRRO = BAI.BAIRRO
LEFT OUTER JOIN TIPOLOGRADOURO TIPOLOG ON
    LOG.TIPOLOGRADOURO = TIPOLOG.TIPOLOGRADOURO;
