select dividausu.usuario,
       divida.entidade,
       divida.exercicio,
       divida.guiarecolhimento as divida,
       divida.descricao as descricaoDivida,
       case
         when coalesce(dividausu.inserir, 'N') =  'S'
           then 1
             else 0
       end as inserir,
       case
         when coalesce(dividausu.cancelar, 'N') =  'S'
           then 1
             else 0
       end as cancelar
from tribguiarecolhimento divida
inner join tribguiarecolhimentousuario dividausu
             on divida.entidade         = dividausu.entidade
            and divida.exercicio        = dividausu.exercicio
            and divida.guiarecolhimento = dividausu.guiarecolhimento
where divida.entidade = :entidade
and divida.exercicio = :exercicio
and dividausu.usuario = :usuario
union
select usuario.usuario,
       divida.entidade,
       divida.exercicio,
       divida.guiarecolhimento as divida,
       divida.descricao as descricaoDivida,
       0 as inserir,
       0 as cancelar
from tribguiarecolhimento divida, usuario usuario
where divida.entidade = :entidade
and divida.exercicio = :exercicio
and usuario.usuario = :usuario
and not exists (select 1
                from tribguiarecolhimentousuario dividausu
                where dividausu.entidade = divida.entidade
                and   dividausu.exercicio = divida.exercicio
                and   dividausu.guiarecolhimento = divida.guiarecolhimento
                and   dividausu.usuario = usuario.usuario)