SELECT DISTINCT
  TD.ENTIDADE AS ENTIDADE,
  TD.EXERCICIO AS EXERCICIO,
  TD.TIPOCADASTRO AS TIPOCADASTRO,
  TD.CADASTROGERAL AS CADASTROGERAL,
  TD.GUIARECOLHIMENTO AS DIVIDA,
  TD.SUBDIVIDA AS SUBDIVIDA,
  TD.IDDEBITO AS IDDEBITO,
  COALESCE(TD.IDPARCELAMENTO, TD.IDREPARCELAMENTO) AS IDPARCELAMENTO
FROM TRIBPAGAMENTO               TP
JOIN TRIBPAGAMENTOBLOQUETO      TPB ON ( TP.ENTIDADE = TPB.ENTIDADE
                                   AND  TP.EXERCICIOPAGAMENTO = TPB.EXERCICIOPAGAMENTO
                                   AND  TP.PAGAMENTO = TPB.PAGAMENTO )
JOIN TRIBPAGAMENTODEBITO        TPD ON ( TPB.IDPAGAMENTOBLOQUETO = TPD.IDPAGAMENTOBLOQUETO )
JOIN TRIBDEBITOPARCELARECEITA  TDPR ON ( TPD.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA )
JOIN TRIBDEBITO                  TD ON ( TDPR.ENTIDADE = TD.ENTIDADE
                                   AND  TDPR.EXERCICIO = TD.EXERCICIO
                                   AND  TDPR.TIPOCADASTRO = TD.TIPOCADASTRO
                                   AND  TDPR.CADASTROGERAL = TD.CADASTROGERAL
                                   AND  TDPR.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
                                   AND  TDPR.SUBDIVIDA = TD.SUBDIVIDA )
JOIN TRIBGUIARECOLHIMENTO       TGR ON ( TD.ENTIDADE = TGR.ENTIDADE
                                   AND  TD.EXERCICIO = TGR.EXERCICIO
                                   AND  TD.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO)
WHERE TP.ENTIDADE = :entidade
  AND TP.EXERCICIOPAGAMENTO = :exerciciopagamento
  AND TP.PAGAMENTO = :pagamento
  %s
  AND NOT EXISTS (SELECT 1
                  FROM TRIBDEBITOPARCELA          TDP
                  JOIN TRIBSITUACAOPARCELA        TSP ON (TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA)
                  JOIN TRIBTIPOSITUACAOPARCELA   TTSP ON (TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA
                                                     AND  TTSP.TIPO = 'A')
                  WHERE TDP.ENTIDADE = TD.ENTIDADE
                    AND TDP.EXERCICIO = TD.EXERCICIO
                    AND TDP.TIPOCADASTRO = TD.TIPOCADASTRO
                    AND TDP.CADASTROGERAL = TD.CADASTROGERAL
                    AND TDP.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
                    AND TDP.SUBDIVIDA = TD.SUBDIVIDA)
ORDER BY TD.ENTIDADE, TD.EXERCICIO, TD.TIPOCADASTRO, TD.CADASTROGERAL, TD.GUIARECOLHIMENTO, TD.SUBDIVIDA