SELECT GER.TIPOCADASTRO,
       GER.CADASTROGERAL,
       PES.PESSOA,
       PES.NOME,
       PES.CNPJ_CPF AS CPFCNPJ,
       LOGR.DESCRICAO AS RUA,
       GER.NUMERO,
       GER.COMPLEMENTO,
       GER.CEP,
       CID.DESCRICAO AS CIDADE,
       UNI.DESCRICAO AS ESTADO,
       GER.IDCADASTROGERALISS,
       COALESCE(SIT_IMOB.SITUACAOIMOBILIARIO, SIT_MOB.SITUACAOMOBILIARIO) AS SITUACAO,
       COALESCE(TS_IMOB.DESCRICAO, TS_MOB.DESCRICAO) AS DESCSITUACAO,
       CAD_MOB.NUMEROALVARA,
       CAD_MOB.EXERCICIOALVARA,
       CAD_MOB.ATIVIDADEPRINCIPAL,
       CAD_MOB.OBSERVACAOALVARA,
       CAD_MOB.DATAABERTURA,
       CAD_MOB.DATAENCERRAMENTO,
       CAD_MOB.DATAVALIDADEALVARA,
       CAD_MOB.DATAULTIMAFISCALIZACAO,
       CASE
         WHEN (SELECT COUNT(*)
               FROM TRIBREPRESENTANTELEGAL A
               WHERE A.PESSOA = PES.PESSOA
                 AND A.TIPOCADASTRO = GER.TIPOCADASTRO
                 AND A.CADASTROGERAL = GER.CADASTROGERAL) = 1 THEN 'S'
         ELSE 'N'
       END AS REPRESENTANTELEGAL,
       CASE
         WHEN (SELECT COUNT(1)
               FROM TRIBDEBITO DEB
               INNER JOIN TRIBDEBITOPARCELA PAR ON DEB.ENTIDADE = PAR.ENTIDADE
                                               AND DEB.EXERCICIO = PAR.EXERCICIO
                                               AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
                                               AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
                                               AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
                                               AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
               INNER JOIN TRIBGUIARECOLHIMENTO GUIA ON DEB.ENTIDADE = GUIA.ENTIDADE
                                                   AND DEB.EXERCICIO = GUIA.EXERCICIO
                                                   AND DEB.GUIARECOLHIMENTO = GUIA.GUIARECOLHIMENTO
               INNER JOIN TRIBGUIARECOLHIMENTOFORMAPAG FPAG ON DEB.ENTIDADE = FPAG.ENTIDADE
                                                           AND DEB.EXERCICIO = FPAG.EXERCICIO
                                                           AND DEB.GUIARECOLHIMENTO = FPAG.GUIARECOLHIMENTO
               INNER JOIN TRIBFORMAPAGAMENTO FP ON FP.FORMAPAGAMENTO = FPAG.FORMAPAGAMENTO
               WHERE DEB.ENTIDADE = :entidade
                 AND DEB.EXERCICIO = :exercicio
                 AND DEB.TIPOCADASTRO = GER.tipoCadastro
                 AND DEB.CADASTROGERAL = GER.cadastroGeral
                 AND DEB.CONSTITUIDO = 'S'
                 AND FPAG.DISPONIVELWEB = 'S'
                 AND FPAG.VENCIMENTO >= :dataVencimento
                 AND (FP.TIPOFORMAPAGAMENTO = 'U'
                 AND NOT EXISTS(SELECT 1
                                FROM TRIBDEBITOPARCELA PARSUB
                                INNER JOIN TRIBSITUACAOPARCELA SITSUB ON SITSUB.SITUACAOPARCELA = PARSUB.SITUACAODEBITO
                                INNER JOIN TRIBTIPOSITUACAOPARCELA TIPSUB ON SITSUB.TIPOSITUACAOPARCELA = TIPSUB.TIPOSITUACAOPARCELA
                                WHERE PARSUB.ENTIDADE = DEB.ENTIDADE
                                  AND PARSUB.EXERCICIO = DEB.EXERCICIO
                                  AND PARSUB.TIPOCADASTRO = DEB.TIPOCADASTRO
                                  AND PARSUB.CADASTROGERAL = DEB.CADASTROGERAL
                                  AND PARSUB.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO
                                  AND PARSUB.SUBDIVIDA = DEB.SUBDIVIDA
                                  AND TIPSUB.TIPO <> 'A')
                 )) > 1 THEN 1
         ELSE 0
       END                                                       AS POSSUICOTAUNICA
FROM PESSOA PES
INNER JOIN (SELECT P.PESSOA, P.CNPJ_CPF, A.TIPOCADASTRO, A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBREPRESENTANTELEGAL A ON P.PESSOA = A.PESSOA
            LEFT JOIN TRIBTIPOREPRESENTANTE B ON A.TIPOREPRESENTANTE = B.TIPOREPRESENTANTE
                                             AND B.ADMINISTRADOR = 'S'
            UNION
            SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBPROPRIETARIO A ON P.PESSOA = A.PESSOA) CAD ON PES.PESSOA = CAD.PESSOA
                                                                     AND PES.CNPJ_CPF = CAD.CNPJ_CPF
INNER JOIN TRIBCADASTROGERAL GER ON GER.TIPOCADASTRO = CAD.TIPOCADASTRO
                                AND GER.CADASTROGERAL = CAD.CADASTROGERAL
LEFT OUTER JOIN LOGRADOURO LOGR ON LOGR.CIDADE = GER.CIDADE
                               AND LOGR.LOGRADOURO = GER.LOGRADOURO
LEFT OUTER JOIN CIDADE CID ON CID.CIDADE = GER.CIDADE
LEFT OUTER JOIN UNIDADEFEDERACAO UNI ON UNI.UNIDADEFEDERACAO = CID.UNIDADEFEDERACAO
                                    AND UNI.PAIS = CID.PAIS
LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO CAD_IMOB ON GER.TIPOCADASTRO = CAD_IMOB.TIPOCADASTRO
                                                AND GER.CADASTROGERAL = CAD_IMOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO,
                 A.CADASTROGERAL,
                 MAX(A.SEQUENCIA) AS SEQUENCIA
                 FROM TRIBIMOBILIARIOSITUACAO A
                 WHERE A.ATUAL = 'S'
                 GROUP BY A.TIPOCADASTRO,
                          A.CADASTROGERAL) S_IMOB ON CAD_IMOB.TIPOCADASTRO = S_IMOB.TIPOCADASTRO
                                                                 AND CAD_IMOB.CADASTROGERAL = S_IMOB.CADASTROGERAL
LEFT OUTER JOIN TRIBIMOBILIARIOSITUACAO SIT_IMOB ON S_IMOB.TIPOCADASTRO = SIT_IMOB.TIPOCADASTRO
                                                AND S_IMOB.CADASTROGERAL = SIT_IMOB.CADASTROGERAL
                                                AND S_IMOB.SEQUENCIA = SIT_IMOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOIMOBILIARIO TS_IMOB ON SIT_IMOB.SITUACAOIMOBILIARIO = TS_IMOB.SITUACAOIMOBILIARIO
LEFT OUTER JOIN TRIBCADASTROMOBILIARIO CAD_MOB ON GER.TIPOCADASTRO = CAD_MOB.TIPOCADASTRO
                                              AND GER.CADASTROGERAL = CAD_MOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO, A.CADASTROGERAL, MAX(A.SEQUENCIA) AS SEQUENCIA
                FROM TRIBMOBILIARIOSITUACAO A
                WHERE A.ATUAL = 'S'
                GROUP BY A.TIPOCADASTRO,
                         A.CADASTROGERAL) S_MOB ON CAD_MOB.TIPOCADASTRO = S_MOB.TIPOCADASTRO
                                               AND CAD_MOB.CADASTROGERAL = S_MOB.CADASTROGERAL
LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO SIT_MOB ON S_MOB.TIPOCADASTRO = SIT_MOB.TIPOCADASTRO
                                              AND S_MOB.CADASTROGERAL = SIT_MOB.CADASTROGERAL
                                              AND S_MOB.SEQUENCIA = SIT_MOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOMOBILIARIO TS_MOB ON SIT_MOB.SITUACAOMOBILIARIO = TS_MOB.SITUACAOMOBILIARIO
WHERE PES.CNPJ_CPF = :cnpjcpf
  AND GER.EXCLUSAOLOGICA = 'N'
  AND EXISTS(SELECT 1
             FROM TRIBDEBITO DEB
             INNER JOIN TRIBDEBITOPARCELA PAR ON PAR.ENTIDADE = DEB.ENTIDADE
                                             AND PAR.EXERCICIO = DEB.EXERCICIO
                                             AND PAR.TIPOCADASTRO = DEB.TIPOCADASTRO
                                             AND PAR.CADASTROGERAL = DEB.CADASTROGERAL
                                             AND PAR.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO
                                             AND PAR.SUBDIVIDA = DEB.SUBDIVIDA
             INNER JOIN TRIBSITUACAOPARCELA SIT ON SIT.SITUACAOPARCELA = PAR.SITUACAODEBITO
             INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON TIP.TIPOSITUACAOPARCELA = SIT.SITUACAOPARCELA
             WHERE DEB.TIPOCADASTRO = GER.TIPOCADASTRO
               AND DEB.CADASTROGERAL = GER.CADASTROGERAL
               AND DEB.CONSTITUIDO = 'S'
               AND TIP.TIPO = 'A')
