SELECT DEBITOPARCELARECEITA.RECEITA AS tributo,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORPRINCIPAL, 0)) AS valorPrincipal,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORJUROS, 0)) AS valorJuros,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORMULTA, 0)) AS valorMulta,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORCORRECAO, 0)) AS valorCorrecao,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROSFINAN,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO,0)) valorDesconto
FROM TRIBCREDITOCONTRIBUINTE CREDITOCONTRIBUINTE
LEFT JOIN TRIBCREDITOCONTRIBUINTEITEM CREDITOCONTRIBUINTEITEM
        ON CREDITOCONTRIBUINTE.ENTIDADE = CREDITOCONTRIBUINTEITEM.ENTIDADE AND
           CREDITOCONTRIBUINTE.EXERCICIO = CREDITOCONTRIBUINTEITEM.EXERCICIO AND
           CREDITOCONTRIBUINTE.CREDITOCONTRIBUINTE = CREDITOCONTRIBUINTEITEM.CREDITOCONTRIBUINTE
LEFT JOIN CONTABANCARIA
        ON CREDITOCONTRIBUINTE.ENTIDADE = CONTABANCARIA.ENTIDADE AND
           CREDITOCONTRIBUINTE.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
        ON CREDITOCONTRIBUINTEITEM.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
LEFT JOIN TRIBRECEITA RECEITA ON DEBITOPARCELARECEITA.ENTIDADE = RECEITA.ENTIDADE AND
                                 DEBITOPARCELARECEITA.EXERCICIO = RECEITA.EXERCICIO AND
                                 DEBITOPARCELARECEITA.RECEITA = RECEITA.RECEITA
LEFT JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CREDITOCONTRIBUINTE.DATA = :dataLancamento
AND CONTABANCARIA.INTEGRAARRECADACAO = 'S'
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA