SELECT A.ENTIDADE,
       A.EXERCICIOPAGAMENTO,
       A.PAGAMENTO,
       EP.DATA AS DATAMOVIMENTACAO,
       C.VALORPRINCIPAL + COALESCE(C.VALORPAGOMAIOR,0) AS VALORPRINCIPAL,
       C.VALORJUROS,
       C.VALORMULTA,
       C.VALORCORRECAO,
       CASE
          WHEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0) > 0
             THEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0)
             ELSE COALESCE(C.VALORDESCONTO,0) + COALESCE(C.VALORPAGOMENOR,0)
       END AS VALORDESCONTO,
       C.VALORPAGOMENOR,
       C.VALORPAGOMAIOR,
       C.VALORPAGO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBESTORNOPAGAMENTO EP
LEFT OUTER JOIN TRIBPAGAMENTO A
 ON EP.ENTIDADE = A.ENTIDADE
AND EP.EXERCICIOPAGAMENTO = A.EXERCICIOPAGAMENTO
AND EP.PAGAMENTO = A.PAGAMENTO
LEFT OUTER JOIN TRIBESTORNOPAGAMENTOITEM EPI
 ON EP.ENTIDADE = EPI.ENTIDADE
AND EP.EXERCICIO = EPI.EXERCICIO
AND EP.ESTORNO = EPI.ESTORNO
LEFT OUTER JOIN TRIBPAGAMENTODEBITO C
 ON EPI.IDPAGAMENTOBLOQUETO = C.IDPAGAMENTOBLOQUETO
AND EPI.IDDEBITOPARCELARECEITA = C.IDDEBITOPARCELARECEITA
LEFT OUTER JOIN CONTABANCARIA CB
 ON EP.ENTIDADE = CB.ENTIDADE
AND EP.CONTABANCARIAESTORNO = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON C.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'
AND COALESCE(EP.REABILITADO, 'N') = 'N'