SELECT DISTINCT
       td.idDebito,
       tdida.parcela
  FROM tribdocumento                   doc
  JOIN tribdocumentoitempeticao       tdip ON ( doc.entidade = tdip.entidade
                                           AND  doc.exercicio = tdip.exercicio
                                           AND  doc.tipodocumento = tdip.tipodocumento
                                           AND  doc.documento = tdip.documento )
  JOIN tribdocumentoitemdividaativa  tdida ON ( tdip.entidade = tdida.entidade
  										   AND  tdip.exerciciocertidao = tdida.exercicio
  										   AND  tdip.tipodocumentocertidao = tdida.tipodocumento
  										   AND  tdip.documentocertidao = tdida.documento
  										   AND  tdip.sequenciacertidao = tdida.sequenciaitem )
  JOIN tribdebitoparcela               tdp ON ( tdida.entidade = tdp.entidade
                                           AND  tdida.exerciciodebito = tdp.exercicio
                                           AND  tdida.tipocadastro = tdp.tipocadastro
                                           AND  tdida.cadastrogeral = tdp.cadastrogeral
                                           AND  tdida.guiarecolhimento = tdp.guiarecolhimento
                                           AND  tdida.subdivida = tdp.subdivida
                                           AND  tdida.parcela = tdp.parcela )
  JOIN tribsituacaoparcela             tsp ON ( tdp.situacaodebito = tsp.situacaoparcela )
  JOIN tribtiposituacaoparcela        ttsp ON ( tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela )
  JOIN tribdebito                       td ON ( tdp.entidade = td.entidade
                                           AND  tdp.exercicio = td.exercicio
                                           AND  tdp.tipocadastro = td.tipocadastro
                                           AND  tdp.cadastrogeral = td.cadastrogeral
                                           AND  tdp.guiarecolhimento = td.guiarecolhimento
                                           AND  tdp.subdivida = td.subdivida )
 WHERE doc.idkey = :documento
   AND ttsp.tipo = 'A'
 ORDER BY td.idDebito, tdida.parcela