Select cert.idkey as idDocumento,
       cert.pessoa
  From TribDocumento cert
 left join Pessoa p on ( cert.Pessoa = p.Pessoa )
 left join TribCadastroGeral cg
  on cert.TipoCadastro = cg.TipoCadastro
 and cert.CadastroGeral = cg.CadastroGeral
 where cert.Entidade      = :entidade
   and cert.TipoDocumento = 26
   and cert.Cancelado     = 'N'
   and cg.ExclusaoLogica  = 'N'
   and not exists(select
            1
        from
            tribdocumento doc
        inner join tribdocumentopeticaocda tdpc
            on doc.idkey=tdpc.idpeticao
        where
            tdpc.idcertidaodividaativa=cert.idkey
            and doc.cancelado='N')
   $[FILTROS]
Order by cert.Exercicio,
         cert.Documento,
         p.nome,
         cert.TipoCadastro,
         cert.CadastroGeral