/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CadastroImobiliarioValidator {
    private final ParametroEntidadeService parametroEntidadeService;
    private final ParametroGeralService parametroGeralService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public CadastroImobiliarioValidator(ParametroEntidadeService parametroEntidadeService, ParametroGeralService parametroGeralService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.parametroEntidadeService = parametroEntidadeService;
        this.parametroGeralService = parametroGeralService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }

    private Boolean utilizaSituacaoSegmento() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SITUACAO_SEGMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean getParametroValidaTestadaCadastro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_TESTADA_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean utilizaTestadaGenerica() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public void validaCadastroImobiliario(CadastroImobiliario cadastroImobiliario) {
        this.validaProprietario(cadastroImobiliario);
        this.validaInformacoesImobiliaria(cadastroImobiliario);
        this.validaComposicao(cadastroImobiliario);
    }

    private void validaProprietario(CadastroImobiliario cadastroImobiliario) {
        this.validaExisteProprietarioPrincipal(cadastroImobiliario);
        this.validaCorresponsavelPrincipal(cadastroImobiliario);
        this.validaPercentualTotal(cadastroImobiliario);
        this.validaProprietarioDuplicado(cadastroImobiliario);
    }

    private void validaTestadaPrincipalDistritoSetorQuadra(CadastroImobiliario cadastroImobiliario) {
        cadastroImobiliario.getTestadas().stream().filter(CadastroImobiliarioTestada::getPrincipal).findFirst().map(CadastroImobiliarioTestada::getLogradouroTestada).ifPresent(logradouroTestada -> {
            ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
            if (!(cadastroImobiliario.getDistritoLocalizacao().getDistrito().equals(logradouroTestada.getSetorQuadra().getSetor().getDistrito().getDistrito()) && cadastroImobiliario.getSetorLocalizacao().getSetor().equals(logradouroTestada.getSetorQuadra().getSetor().getSetor()) && cadastroImobiliario.getQuadraLocalizacao().getQuadra().equals(logradouroTestada.getSetorQuadra().getQuadra()))) {
                throw new EloValidationException(String.format("O logradouro: %s %s n\u00e3o \u00e9 compat\u00edvel com as configura\u00e7\u00f5es de %s: %s, %s: %s e %s: %s.", logradouroTestada.getLogradouro().getTipoLogradouroDescricao(), logradouroTestada.getLogradouro().getDescricao(), configuracao.getDistrito().getDescricao(), cadastroImobiliario.getDistritoLocalizacao().getDistrito(), configuracao.getSetor().getDescricao(), cadastroImobiliario.getSetorLocalizacao().getSetor(), configuracao.getQuadra().getDescricao(), cadastroImobiliario.getQuadraLocalizacao().getQuadra()));
            }
        });
    }

    private void validaInformacoesImobiliaria(CadastroImobiliario cadastroImobiliario) {
        this.validaAreaMaiorQueZero(cadastroImobiliario);
        this.validaTestadaPrincipal(cadastroImobiliario);
        if (!this.utilizaTestadaGenerica().booleanValue() && this.getParametroValidaTestadaCadastro().booleanValue()) {
            this.validaTestadaPrincipalUtilizaCalculo(cadastroImobiliario);
            this.validaTestadaPrincipalDistritoSetorQuadra(cadastroImobiliario);
        }
        this.validaTestadaDuplicada(cadastroImobiliario);
    }

    private void validaComposicao(CadastroImobiliario cadastroImobiliario) {
        this.validaAreaConstruida(cadastroImobiliario);
        this.validaComposicaoSegmento(cadastroImobiliario);
    }

    private Boolean existeLancaImposto(CadastroImobiliario cadastroImobiliario) {
        return cadastroImobiliario.getSegmentos().stream().map(CadastroImobiliarioSegmento::getSituacaoSegmento).anyMatch(SituacaoSegmentoImob::getLancaImposto);
    }

    private void validaExisteProprietarioPrincipal(CadastroImobiliario cadastroImobiliario) {
        if (cadastroImobiliario.getProprietarios().stream().noneMatch(Proprietario::getPrincipal)) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel salvar um cadastro sem um propriet\u00e1rio principal.");
        }
    }

    private void validaCorresponsavelPrincipal(CadastroImobiliario cadastroImobiliario) {
        boolean existeCoResponsaveis = cadastroImobiliario.getProprietarios().stream().map(Proprietario::getVinculo).map(Vinculo::getTipoVinculo).anyMatch(TipoVinculo::isCoResponsavel);
        boolean existeCoResponsaveisPrincipais = cadastroImobiliario.getProprietarios().stream().anyMatch(Proprietario::getCoResponsavelPrincipal);
        if (existeCoResponsaveis && !existeCoResponsaveisPrincipais) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel salvar um cadastro sem um Co-Respons\u00e1vel principal.");
        }
    }

    private void validaPercentualTotal(CadastroImobiliario cadastroImobiliario) {
        BigDecimal percentualTotal = cadastroImobiliario.getProprietarios().stream().map(Proprietario::getPercentual).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimal.valueOf(100.0).compareTo(percentualTotal) != 0) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel salvar um Propriet\u00e1rio com percentual diferente de 100%.");
        }
    }

    private void validaComposicaoSegmento(CadastroImobiliario cadastroImobiliario) {
        if (TipoImovel.PREDIAL.equals((Object)cadastroImobiliario.getTipoImovel()) && this.utilizaSituacaoSegmento().booleanValue()) {
            if (cadastroImobiliario.getSegmentos().stream().anyMatch(segmento -> Objects.isNull(segmento.getSituacaoSegmento()))) {
                throw new EloValidationException("Situa\u00e7\u00e3o do segmento \u00e9 obrigat\u00f3ria.");
            }
            if (Boolean.FALSE.equals(this.existeLancaImposto(cadastroImobiliario))) {
                throw new EloValidationException("Deve haver pelo menos um segmento com situa\u00e7\u00e3o Lan\u00e7a Imposto.");
            }
        }
    }

    private void validaProprietarioDuplicado(CadastroImobiliario cadastroImobiliario) {
        List pessoasDuplicadas = cadastroImobiliario.getProprietarios().stream().map(Proprietario::getPessoa).collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(pessoaListEntry -> ((List)pessoaListEntry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!pessoasDuplicadas.isEmpty()) {
            String nomesPessoasDuplicadas = pessoasDuplicadas.stream().map(Pessoa::getNome).collect(Collectors.joining(System.lineSeparator()));
            throw new EloValidationException(String.format("Necess\u00e1rio remover os seguintes propriet\u00e1rios duplicados: %n %s", nomesPessoasDuplicadas));
        }
    }

    private void validaAreaMaiorQueZero(CadastroImobiliario cadastroImobiliario) {
        if (Objects.isNull(cadastroImobiliario.getAreaLote()) || cadastroImobiliario.getAreaLote().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException("\u00c1rea do lote deve ser maior que zero");
        }
    }

    private void validaTestadaPrincipal(CadastroImobiliario cadastroImobiliario) {
        if (Boolean.TRUE.equals(this.utilizaTestadaGenerica())) {
            this.validaTestadaGenericaPrincipal(cadastroImobiliario);
        } else {
            this.validaTestadaNormalPrincipal(cadastroImobiliario);
        }
    }

    private void validaTestadaPrincipalUtilizaCalculo(CadastroImobiliario cadastroImobiliario) {
        boolean naoExisteTestadaPrincipalParaCalculo = cadastroImobiliario.getTestadas().stream().noneMatch(testada -> testada.getPrincipal() != false && testada.getUtilizaParaCalculo() != false);
        if (naoExisteTestadaPrincipalParaCalculo) {
            throw new EloValidationException("Deve haver pelo menos uma testada principal com a op\u00e7\u00e3o 'Utiliza para c\u00e1lculo' marcada.");
        }
    }

    private void validaTestadaNormalPrincipal(CadastroImobiliario cadastroImobiliario) {
        boolean naoExisteTestadaPrincipal = cadastroImobiliario.getTestadas().stream().noneMatch(CadastroImobiliarioTestada::getPrincipal);
        if (naoExisteTestadaPrincipal) {
            throw new EloValidationException("Deve haver pelo menos uma testada principal.");
        }
    }

    private void validaTestadaGenericaPrincipal(CadastroImobiliario cadastroImobiliario) {
        boolean naoExisteTestadaGenericaPrincipal = cadastroImobiliario.getTestadasGenericas().stream().noneMatch(CadastroImobiliarioTestadaGenerica::getPrincipal);
        if (naoExisteTestadaGenericaPrincipal) {
            throw new EloValidationException("Deve haver pelo menos uma testada gen\u00e9rica principal.");
        }
    }

    private void validaTestadaDuplicada(CadastroImobiliario cadastroImobiliario) {
        List testadasDuplicadas;
        if (!this.utilizaTestadaGenerica().booleanValue() && !(testadasDuplicadas = cadastroImobiliario.getTestadas().stream().map(CadastroImobiliarioTestada::getLogradouroTestada).collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(logradouro -> ((List)logradouro.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
            String logradourosDuplicados = testadasDuplicadas.stream().map(testada -> testada.getId() + " - " + testada.getLogradouro().getDescricao()).collect(Collectors.joining(System.lineSeparator()));
            throw new EloValidationException(String.format("Necess\u00e1rio remover as seguintes testadas duplicadas: %n %s", logradourosDuplicados));
        }
    }

    private void validaAreaConstruida(CadastroImobiliario cadastroImobiliario) {
        boolean existeAreaConstruidaZero = cadastroImobiliario.getSegmentos().stream().map(CadastroImobiliarioSegmento::getAreaConstruida).anyMatch(area -> BigDecimal.ZERO.compareTo((BigDecimal)area) >= 0);
        if (existeAreaConstruidaZero) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel salvar um segmento com a \u00e1rea constru\u00edda menor ou igual a zero.");
        }
    }
}

