/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldo;
import br.com.elotech.tributos.dto.ImplantacaoSaldoImpressaoDTO;
import br.com.elotech.tributos.dto.ImplantacaoSaldoReceitaDTO;
import br.com.elotech.tributos.dto.ImplantacaoSaldoReport;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoImplantacaoSaldo;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeGroupedDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoInformationDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoTributosDTO;
import br.com.elotech.tributos.report.loader.ConsultaImplantacaoSaldoParamLoader;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ImplantacaoSaldoService
extends CrudService<ImplantacaoSaldo, Long> {
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ConsultaImplantacaoSaldoParamLoader consultaImplantacaoSaldoParamLoader;

    public List<ImplantacaoSaldoContabilidadeDTO> findDadosContabilidade(Long entidade, Long exercicio) {
        return this.implantacaoSaldoRepository.findDadosContabilidade(entidade, exercicio, SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO.getValue());
    }

    public List<ImplantacaoSaldoContabilidadeGroupedDTO> findDadosContabilidadeGrouped(Long entidade, Long exercicio) {
        return this.implantacaoSaldoRepository.findDadosContabilidadeGrouped(entidade, exercicio, SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO.getValue());
    }

    public Page<ImplantacaoSaldoDebitoParcelaDTO> findDebitoParcelaTributos(ImplantacaoSaldoReceitaDTO dto, Pageable pageable) {
        return this.implantacaoSaldoRepository.findDebitoParcelaTributos(dto, SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO.getValue(), pageable);
    }

    public List<ImplantacaoSaldoTributosDTO> findTributosDetalhados(ImplantacaoSaldoReceitaDTO dto) {
        return this.implantacaoSaldoRepository.findTributosDetalhados(dto, SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO.getValue());
    }

    public ImplantacaoSaldoInformationDTO getInformationFromLastImplantacaoSaldo(Long entidade, Long exercicio) {
        return this.implantacaoSaldoRepository.getInformationFromLastImplantacaoSaldo(entidade, exercicio, SituacaoImplantacaoSaldo.AGUARDANDO_CONTABILIZACAO.getValue());
    }

    public byte[] printImplantacaoSaldo(ImplantacaoSaldoImpressaoDTO dto) {
        ImplantacaoSaldoReport report = ImplantacaoSaldoReport.from((ImplantacaoSaldoImpressaoDTO)dto);
        DatasetLoader mainDatasetLoader = DatasetLoaders.single((DatasetRecord)report, ImplantacaoSaldoReport.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.consultaImplantacaoSaldoParamLoader).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("implantacao-saldo-sim-am.jrxml")).setReportDatasource(datasource).build().exportToPdf();
    }

    @Generated
    public ImplantacaoSaldoService(ImplantacaoSaldoRepository implantacaoSaldoRepository, ReportFileResolverFactory reportFileResolverFactory, ConsultaImplantacaoSaldoParamLoader consultaImplantacaoSaldoParamLoader) {
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.consultaImplantacaoSaldoParamLoader = consultaImplantacaoSaldoParamLoader;
    }
}

