/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonialPorTipoMovimentoDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ItemIntegracaoPatrimonial;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialAgrupadorDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.outboxdataintegration.consumer.CTBIntegracaoContabilConsumer;
import br.com.elotech.tributos.repository.integracaocontabil.IntegracaoPatrimonialRepository;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoPatrimonialService
extends CrudService<IntegracaoPatrimonial, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CTBIntegracaoContabilConsumer.class);
    private final IntegracaoPatrimonialRepository integracaoPatrimonialRepository;
    private final MovimentacaoDiariaService movimentacaoDiariaService;

    public IntegracaoPatrimonialService(IntegracaoPatrimonialRepository integracaoPatrimonialRepository, MovimentacaoDiariaService movimentacaoDiariaService) {
        this.integracaoPatrimonialRepository = integracaoPatrimonialRepository;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
    }

    public List<IntegracaoPatrimonial> geraIntegracaoPatrimonial(List<LocalDate> datasMovimento) {
        List movimentacoes = this.integracaoPatrimonialRepository.findInscricoesDiversas(datasMovimento);
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findCancelamentos(datasMovimento));
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornoCancelamentos(datasMovimento));
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findParcelamentos(datasMovimento));
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findEstornosParcelamentos(datasMovimento));
        movimentacoes.addAll(this.integracaoPatrimonialRepository.findReabilitacoesParcelamentos(datasMovimento));
        List integracoesPatrimoniais = movimentacoes.stream().collect(Collectors.groupingBy(ItemIntegracaoPatrimonialDTO::toItemIntegracaoPatrimonialAgrupador)).entrySet().stream().map(arg_0 -> this.toIntegracaoPatrimonial(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        return this.integracaoPatrimonialRepository.saveAll(integracoesPatrimoniais);
    }

    private IntegracaoPatrimonial toIntegracaoPatrimonial(Map.Entry<ItemIntegracaoPatrimonialAgrupadorDTO, List<ItemIntegracaoPatrimonialDTO>> movimentacoes) {
        IntegracaoPatrimonial integracaoPatrimonial;
        LocalDate dataMovimento;
        Long entidade = movimentacoes.getKey().getEntidade();
        IntegracaoPatrimonial integracaoPatrimonialFound = this.integracaoPatrimonialRepository.findByEntidadeAndDataMovimento(entidade, dataMovimento = movimentacoes.getKey().getDataMovimentacao());
        if (Objects.nonNull(integracaoPatrimonialFound) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)integracaoPatrimonialFound.getSituacaoIntegracaoPatrimonial())) {
            return null;
        }
        IntegracaoPatrimonial integracaoPatrimonial2 = integracaoPatrimonial = Objects.isNull(integracaoPatrimonialFound) ? new IntegracaoPatrimonial() : integracaoPatrimonialFound;
        if (Objects.isNull(integracaoPatrimonialFound)) {
            integracaoPatrimonial.setDataMovimento(dataMovimento);
            integracaoPatrimonial.setEntidade(entidade);
            integracaoPatrimonial.setExercicio(Long.valueOf(dataMovimento.getYear()));
        }
        integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO);
        integracaoPatrimonial.getItens().clear();
        List itens = movimentacoes.getValue().stream().map(ItemIntegracaoPatrimonial::from).collect(Collectors.toList());
        integracaoPatrimonial.getItens().addAll(itens);
        return integracaoPatrimonial;
    }

    public void updateStatus(Long id, SituacaoIntegracaoContabil situacao) {
        this.integracaoPatrimonialRepository.findById((Object)id).ifPresent(integracaoPatrimonial -> {
            integracaoPatrimonial.setSituacaoIntegracaoPatrimonial(situacao);
            this.integracaoPatrimonialRepository.save(integracaoPatrimonial);
            LOGGER.info("Situa\u00e7\u00e3o do lote de integra\u00e7\u00e3o patrimonial {} atualizado.", (Object)id);
            if (SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)situacao)) {
                this.movimentacaoDiariaService.reverterIntegracaoData(integracaoPatrimonial.getDataMovimento());
                LOGGER.info("Movimenta\u00e7\u00e3o di\u00e1ria na data {}, atualizada para {}.", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)integracaoPatrimonial.getDataMovimento()), (Object)SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao());
            }
        });
        LOGGER.info("Atualiza\u00e7\u00e3o de lote de integra\u00e7\u00e3o patrimonial finalizado.");
    }

    public List<IntegracaoPatrimonialPorTipoMovimentoDTO> findTotaisPorTipoMovimentoAndId(Long id) {
        IntegracaoPatrimonial integracaoPatrimonial = (IntegracaoPatrimonial)this.integracaoPatrimonialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o Patrimonial %s n\u00e3o encontrada.", id)));
        List totais = this.integracaoPatrimonialRepository.findTotaisPorTipoMovimentoAndId(integracaoPatrimonial.getId());
        totais.sort(Comparator.comparing(total -> total.getTipoMovimento().getDescricao()));
        return totais;
    }

    public TotalizadorIntegracaoPatrimonialDTO getTotalSearch(String search) {
        return this.integracaoPatrimonialRepository.getTotalSearch(search);
    }
}

