/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.repository.integracaocontabil.ArrecadacaoPorTributoRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoPorTributoService {
    private ArrecadacaoPorTributoRepository arrecadacaoPorTributoRepository;

    public ArrecadacaoPorTributoService(ArrecadacaoPorTributoRepository arrecadacaoPorTributoRepository) {
        this.arrecadacaoPorTributoRepository = arrecadacaoPorTributoRepository;
    }

    public ArrecadacaoPorTributoResumoDTO getArrecadacaoPorTributo(FiltroArrecadacaoPorTributoDTO filtro, Pageable pageable) {
        ArrecadacaoPorTributoResumoDTO resumo = new ArrecadacaoPorTributoResumoDTO();
        ArrayList mergeList = new ArrayList();
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findPagamentosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findEstornoPagamentosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findCreditosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findEstornoCreditosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findReabilitacaoEstornoPagamentosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findDevolucaoCreditosPorTributo(filtro));
        mergeList.addAll(this.arrecadacaoPorTributoRepository.findEstornoDevolucaoCreditosPorTributo(filtro));
        ArrecadacaoPorTributoValoresDTO valoresAcumulados = this.reduceValorArrecadacao(Optional.empty(), mergeList);
        resumo.setTotalPrincipal(valoresAcumulados.getValorPrincipal());
        resumo.setTotalJuros(valoresAcumulados.getValorJuros());
        resumo.setTotalMulta(valoresAcumulados.getValorMulta());
        resumo.setTotalCorrecao(valoresAcumulados.getValorCorrecao());
        resumo.setTotalDesconto(valoresAcumulados.getValorDesconto());
        resumo.setTotalLiquido(valoresAcumulados.getValorLiquido());
        resumo.setValoresPaginados(this.getValoresArrecadacaoPorTributo(mergeList, pageable));
        return resumo;
    }

    private Page<ArrecadacaoPorTributoValoresDTO> getValoresArrecadacaoPorTributo(List<ArrecadacaoPorTributoValoresDTO> mergeList, Pageable pageable) {
        ArrayList valoresAgrupados = new ArrayList();
        mergeList.stream().collect(Collectors.groupingBy(ArrecadacaoPorTributoValoresDTO::getTributo)).forEach((tributo, valores) -> valoresAgrupados.add(this.reduceValorArrecadacao(Optional.of(tributo), valores)));
        List valores2 = valoresAgrupados.stream().sorted(Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getTributo)).skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(valores2, pageable, (long)valoresAgrupados.size());
    }

    private ArrecadacaoPorTributoValoresDTO reduceValorArrecadacao(Optional<String> tributo, List<ArrecadacaoPorTributoValoresDTO> valores) {
        return valores.stream().reduce(new ArrecadacaoPorTributoValoresDTO(), (acc, item) -> {
            tributo.ifPresent(arg_0 -> ((ArrecadacaoPorTributoValoresDTO)acc).setTributo(arg_0));
            acc.setValorPrincipal(acc.getValorPrincipal().add(item.getValorPrincipal()));
            acc.setValorJuros(acc.getValorJuros().add(item.getValorJuros()));
            acc.setValorMulta(acc.getValorMulta().add(item.getValorMulta()));
            acc.setValorCorrecao(acc.getValorCorrecao().add(item.getValorCorrecao()));
            acc.setValorDesconto(acc.getValorDesconto().add(item.getValorDesconto()));
            acc.setValorLiquido(acc.getValorPrincipal().add(acc.getValorJuros()).add(acc.getValorMulta()).add(acc.getValorCorrecao()).subtract(acc.getValorDesconto()));
            return acc;
        });
    }
}

