/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.itau;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.config.CustomResponseErrorHandler;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.itau.GerarQrCodePixItauRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.QrCodePixItauErroDTO;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoItauService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoItauService.class);
    private static String ITAU_FLOW_ID = "f68492aa-81ed-4de2-8447-54ff780717a0";
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroGeralService parametroGeralService;
    private final ParametroPixRepository parametroPixRepository;
    private RestTemplate restTemplate = new RestTemplate();

    public String gerarQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog();
        try {
            Validate.notNull((Object)bloqueto, (String)"O boleto \u00e9 obrigat\u00f3rio para gerar o qrcode do pix.");
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
            String txid = this.gerarTxid(bloqueto.getModeloBloqueto().getConvenio().getChavePix());
            String url = String.format("%s/cobv/%s", this.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), txid);
            GerarQrCodePixItauRequestDTO dto = GerarQrCodePixItauRequestDTO.from((Bloqueto)bloqueto);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(bloqueto.getEntidade());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Authorization", String.format("Bearer %s", this.getAccessToken(certificado, senhaCertificado)));
            headers.set("x-itau-correlationID", UUID.randomUUID().toString());
            headers.set("x-itau-flowID", ITAU_FLOW_ID);
            headers.set("x-itau-apikey", clientId);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest("PUT to " + url + "\n" + this.mapper.writeValueAsString((Object)requestEntity));
            JsonNode response = (JsonNode)this.getRestTemplate(certificado, senhaCertificado).exchange(url, HttpMethod.PUT, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            String string = response.get("pixCopiaECola").asText();
            return string;
        }
        catch (RestException e) {
            QrCodePixItauErroDTO dtoErros = this.converteErroResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getAccessToken(byte[] certificado, String senhaCertificado) throws JsonProcessingException {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_ITAU_OAUTH_CLIENTSECRET);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("x-itau-correlationID", UUID.randomUUID().toString());
        headers.set("x-itau-flowID", ITAU_FLOW_ID);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)clientId);
        body.add((Object)"client_secret", (Object)clientSecret);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)this.getRestTemplate(certificado, senhaCertificado).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response.get("access_token").asText();
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }

    private String gerarTxid(String chave) {
        String dataHoraAtual = LocalDateTime.now().toString();
        return DigestUtils.md5Hex((String)(dataHoraAtual + chave));
    }

    private QrCodePixItauErroDTO converteErroResposta(String json) {
        try {
            return (QrCodePixItauErroDTO)this.mapper.readValue(json, QrCodePixItauErroDTO.class);
        }
        catch (JsonProcessingException e) {
            QrCodePixItauErroDTO erroDTO = new QrCodePixItauErroDTO();
            erroDTO.setTitle("Erro ao ler o json do retorno com erro. " + e.getMessage());
            return erroDTO;
        }
    }

    private RestTemplate getRestTemplate(byte[] certificado, String senhaCertificado) throws KeyStoreException, IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyManagementException {
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new CustomResponseErrorHandler());
        if (Objects.isNull(certificado)) {
            return this.restTemplate;
        }
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        clientStore.load(new ByteArrayInputStream(certificado), senhaCertificado.toCharArray());
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        sslContextBuilder.useProtocol("TLS");
        sslContextBuilder.loadKeyMaterial(clientStore, senhaCertificado.toCharArray());
        sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout(10000);
        requestFactory.setReadTimeout(10000);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return this.restTemplate;
    }

    @Generated
    public IntegracaoBoletoItauService(ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroGeralService parametroGeralService, ParametroPixRepository parametroPixRepository) {
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.parametroGeralService = parametroGeralService;
        this.parametroPixRepository = parametroPixRepository;
    }

    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

