/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoBoletoRegistradoReceiver {
    private Map<TipoCodigoBarras, IntegracaoBoletoRegistrado> services;

    public IntegracaoBoletoRegistradoReceiver(List<IntegracaoBoletoRegistrado> services) {
        this.services = services.stream().collect(Collectors.toMap(IntegracaoBoletoRegistrado::getTipoCodigoBarras, Function.identity()));
    }

    public CodigoBarrasDTO receiveRequest(Bloqueto boleto) {
        if (!this.services.containsKey(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras())) {
            throw new IllegalArgumentException("Unknown request type: " + boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        }
        IntegracaoBoletoRegistrado integracaoBoletoRegistrado = (IntegracaoBoletoRegistrado)this.services.get(boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras());
        integracaoBoletoRegistrado.beforeGenerate(boleto);
        CodigoBarrasDTO codigoBarrasDTO = integracaoBoletoRegistrado.generateBoleto(boleto);
        integracaoBoletoRegistrado.afterGenerate(boleto, codigoBarrasDTO);
        return codigoBarrasDTO;
    }
}

