/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import br.com.elotech.tributos.repository.DebitoCarneRepository;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DebitoCarneServiceImpl
implements DebitoCarneService {
    private final DebitoCarneRepository debitoCarneRepository;

    public DebitoCarneServiceImpl(DebitoCarneRepository debitoCarneRepository) {
        this.debitoCarneRepository = debitoCarneRepository;
    }

    public List<DebitoCarneDTO> getDebitosCarne(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral) {
        return this.debitoCarneRepository.getDebitosCarne(entidade, exercicio, tipoCadastro, cadastroGeral);
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(Long idDebito) {
        return this.debitoCarneRepository.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(idDebito);
    }

    public List<DebitoCarneDTO> getDebitosCarneComFormasPagamento(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral) {
        List debitosCarne = this.getDebitosCarne(entidade, exercicio, tipoCadastro, cadastroGeral);
        debitosCarne.forEach(debitoCarne -> {
            List formasPagamento = this.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(debitoCarne.getIdDebito());
            debitoCarne.setFormasPagamento(AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)formasPagamento));
        });
        return debitosCarne;
    }
}

