/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.dto.EnderecoDTO;
import br.com.elotech.tributos.dto.ResponseCepDTO;
import br.com.elotech.tributos.service.CepService;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class CepServiceImpl
implements CepService {
    private final RestTemplate restTemplate;

    public CepServiceImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public EnderecoDTO buscaCep(String cep) {
        String url = String.format("https://viacep.com.br/ws/%s/json", cep);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntityFactory.createJsonHttpEntityWithoutEntity(), ResponseCepDTO.class, new Object[0]);
        if (((ResponseCepDTO)response.getBody()).hasAllNullFields()) {
            throw new EloValidationException("Cep n\u00e3o encontrado");
        }
        return EnderecoDTO.from((ResponseCepDTO)((ResponseCepDTO)response.getBody()));
    }
}

