/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.exception;

public class CancelamentoDebitoException
extends RuntimeException {
    private static final String DEBITO_NOTFOUND = "O D\u00e9bito referente ao exerc\u00edcio %d, d\u00edvida %d e subd\u00edvida %d do cadastro %d/%d n\u00e3o foi encontrado.";
    private static final String DEBITO_CERTIDAO_DIVIDA_ATIVA = "O D\u00e9bito referente ao exerc\u00edcio %d, d\u00edvida %d e subd\u00edvida %d do cadastro %d/%d est\u00e1 em d\u00edvida ativa e n\u00e3o pode ser cancelado.";
    private static final String DEBITO_REPARCELADO = "O D\u00e9bito referente ao exerc\u00edcio %d, d\u00edvida %d e subd\u00edvida %d do cadastro %d/%d est\u00e1 reparcelado, n\u00e3o ser\u00e1 poss\u00edvel realizar o cancelamento.";

    public CancelamentoDebitoException(String message) {
        super(message);
    }

    public static CancelamentoDebitoException debitoCertidaoDividaAtiva(Long exercicio, Long divida, Long subDivida, Long tipoCadastro, Long cadastroGeral) {
        return new CancelamentoDebitoException(String.format(DEBITO_CERTIDAO_DIVIDA_ATIVA, exercicio, divida, subDivida, tipoCadastro, cadastroGeral));
    }

    public static CancelamentoDebitoException debitoReparcelado(Long exercicio, Long divida, Long subDivida, Long tipoCadastro, Long cadastroGeral) {
        return new CancelamentoDebitoException(String.format(DEBITO_REPARCELADO, exercicio, divida, subDivida, tipoCadastro, cadastroGeral));
    }

    public static CancelamentoDebitoException debitoNotFound(Long exercicio, Long divida, Long subDivida, Long tipoCadastro, Long cadastroGeral) {
        return new CancelamentoDebitoException(String.format(DEBITO_NOTFOUND, exercicio, divida, subDivida, tipoCadastro, cadastroGeral));
    }
}

