/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LancamentoCreditoJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job lancamentoCreditoBatchJob;

    public LancamentoCreditoJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="lancamentoCreditoBatchJob") Job lancamentoCreditoBatchJob) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.lancamentoCreditoBatchJob = lancamentoCreditoBatchJob;
    }

    public JobExecution startJob(Long entidade, LocalDate dataInicial, LocalDate dataFinal) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_LANCAMENTO_CREDITO.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial));
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.lancamentoCreditoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

