/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.simam.ImplantacaoSaldo;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoImplantacaoSaldo;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ImplantacaoSaldoJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job implantacaoSaldoBatchJob;
    private final ImplantacaoSaldoRepository implantacaoSaldoRepository;

    public ImplantacaoSaldoJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="implantacaoSaldoBatchJob") Job implantacaoSaldoBatchJob, ImplantacaoSaldoRepository implantacaoSaldoRepository) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.implantacaoSaldoBatchJob = implantacaoSaldoBatchJob;
        this.implantacaoSaldoRepository = implantacaoSaldoRepository;
    }

    public JobExecution startJob(Long entidade, Long exercicio, LocalDate dataFinal) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_IMPLANTACAO_SALDO.getTipo()).stream().anyMatch(job -> entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        Long idControle = this.implantacaoSaldoRepository.findLastIdByExercicio(exercicio);
        if ((long)idControle.compareTo(0L) > 0L) {
            Optional.ofNullable((ImplantacaoSaldo)this.implantacaoSaldoRepository.findOne((Object)idControle)).ifPresent(implSaldo -> {
                if (!SituacaoImplantacaoSaldo.ESTORNADO_CONTABILIDADE.equals((Object)implSaldo.getSituacao())) {
                    throw new EloValidationException(String.format("A Implanta\u00e7\u00e3o de Saldo j\u00e1 foi executada para o exerc\u00edcio %d.", exercicio));
                }
            });
        }
        ImplantacaoSaldo implantacaoSaldo = new ImplantacaoSaldo();
        implantacaoSaldo.setEntidade(entidade);
        implantacaoSaldo.setExercicio(exercicio);
        implantacaoSaldo.setDataReferencia(dataFinal);
        implantacaoSaldo.setDataCriacao(LocalDate.now());
        implantacaoSaldo.setUsuarioCriacao(SecurityUtils.getUserAise());
        implantacaoSaldo.setDataSituacao(implantacaoSaldo.getDataCriacao());
        implantacaoSaldo = (ImplantacaoSaldo)this.implantacaoSaldoRepository.save((Object)implantacaoSaldo);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addLong("idControle", implantacaoSaldo.getId());
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.implantacaoSaldoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

