/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo;

import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimulacaoAcrescimoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoAcrescimoService.class);
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ContextService contextService;

    public SimulacaoAcrescimoService(CalculoAcrescimoService calculoAcrescimoService, ContextService contextService) {
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.contextService = contextService;
    }

    public AcrescimoDTO simular(AcrescimoDTO params) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        params.setExercicio(exercicio);
        params.setEntidade(entidade);
        Stopwatch stopwatch = Stopwatch.createStarted();
        AcrescimoDTO result = this.calculoAcrescimoService.calculaAcrescimos(params);
        stopwatch.stop();
        log.debug("{} ms para calcular o acrescimo", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private AcrescimoDTO simular(AcrescimoDTO params, Long entidade, Long exercicio) {
        params.setExercicio(exercicio);
        params.setEntidade(entidade);
        return this.calculoAcrescimoService.calculaAcrescimos(params);
    }

    public List<AcrescimoDTO> simular(List<AcrescimoDTO> params) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<AcrescimoDTO> response = params.stream().map(param -> Objects.nonNull(param) ? this.simular(param, entidade, exercicio) : null).collect(Collectors.toList());
        stopwatch.stop();
        log.debug("{} ms para calcular {} valores.", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)params.size());
        return response;
    }
}

