/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.movimentacaodiaria.MovimentacaoDiaria;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.dto.MovimentacaoDiariaDTO;
import br.com.elotech.tributos.repository.MovimentacaoDiariaRepository;
import br.com.elotech.tributos.repository.PagamentoLoteRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MovimentacaoDiariaService
extends CrudService<MovimentacaoDiaria, MovimentacaoDiariaId> {
    private static final DateTimeFormatter formatterDate = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter formatterUserDate = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private final MovimentacaoDiariaRepository movimentacaoDiariaRepository;
    private final ContextService contextService;
    private final PagamentoLoteRepository pagamentoLoteRepository;

    public MovimentacaoDiariaService(MovimentacaoDiariaRepository movimentacaoDiariaRepository, ContextService contextService, PagamentoLoteRepository pagamentoLoteRepository) {
        this.movimentacaoDiariaRepository = movimentacaoDiariaRepository;
        this.contextService = contextService;
        this.pagamentoLoteRepository = pagamentoLoteRepository;
    }

    public void abrirDatas(List<LocalDate> datasAbertura) {
        Long entidade = this.contextService.getEntidadePrincipal();
        String usuario = SecurityUtils.getUserAise();
        datasAbertura.forEach(data -> {
            MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
            movimentacaoDiariaId.setEntidade(entidade);
            movimentacaoDiariaId.setData(data);
            MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaRepository.findById((Object)movimentacaoDiariaId).orElseGet(() -> {
                MovimentacaoDiaria movimentacao = new MovimentacaoDiaria();
                movimentacao.setId(movimentacaoDiariaId);
                return movimentacao;
            });
            if (!SituacaoMovimentacaoDiaria.TRIBUTACAO.equals((Object)movimentacaoDiaria.getSituacao()) && !Objects.isNull(movimentacaoDiaria.getSituacao())) {
                throw new EloValidationException(String.format("S\u00f3 \u00e9 permitido a abertura de data com situa\u00e7\u00e3o %s. Verifique a data %s.", SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao(), data.format(formatterUserDate)));
            }
            movimentacaoDiaria.setSituacao(SituacaoMovimentacaoDiaria.ABERTO);
            movimentacaoDiaria.setDataAbertura(LocalDate.now());
            movimentacaoDiaria.setUsuarioAbertura(usuario);
            this.movimentacaoDiariaRepository.save((Object)movimentacaoDiaria);
        });
    }

    public void fecharDatas(List<LocalDate> datasFechamento) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        String usuario = SecurityUtils.getUserAise();
        this.validaLoteAbertoNoDia(entidade, exercicio, datasFechamento);
        datasFechamento.forEach(data -> {
            MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
            movimentacaoDiariaId.setEntidade(entidade);
            movimentacaoDiariaId.setData(data);
            MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaRepository.findById((Object)movimentacaoDiariaId).orElseGet(() -> {
                MovimentacaoDiaria movimentacao = new MovimentacaoDiaria();
                movimentacao.setId(movimentacaoDiariaId);
                return movimentacao;
            });
            if (!SituacaoMovimentacaoDiaria.ABERTO.equals((Object)movimentacaoDiaria.getSituacao()) && !Objects.isNull(movimentacaoDiaria.getSituacao())) {
                throw new EloValidationException(String.format("S\u00f3 \u00e9 permitido o fechamento de data com situa\u00e7\u00e3o %s. Verifique a data %s.", SituacaoMovimentacaoDiaria.ABERTO.getDescricao(), data.format(formatterUserDate)));
            }
            movimentacaoDiaria.setSituacao(SituacaoMovimentacaoDiaria.TRIBUTACAO);
            movimentacaoDiaria.setDataFechamento(LocalDate.now());
            movimentacaoDiaria.setUsuarioFechamento(usuario);
            this.movimentacaoDiariaRepository.save((Object)movimentacaoDiaria);
        });
    }

    private void validaLoteAbertoNoDia(Long entidade, Long exercicio, List<LocalDate> datasFechamento) {
        List pagamentos = this.pagamentoLoteRepository.findByDataMovimentacao(entidade, exercicio, datasFechamento);
        if (pagamentos.stream().anyMatch(pagamentoLoteDTO -> SituacaoPagamentoLote.ABERTO.equals((Object)pagamentoLoteDTO.getSituacao()))) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel fechar os dias pois existem lotes em aberto em algum desses dias.");
        }
    }

    public List<MovimentacaoDiariaDTO> findSituacaoByMesAno(Long entidade, Long mes, Long ano) {
        LocalDate dataInicio = LocalDate.of(ano.intValue(), mes.intValue(), 1);
        LocalDate dataFim = dataInicio.with(TemporalAdjusters.lastDayOfMonth());
        List movimentacaoDiaria = this.movimentacaoDiariaRepository.findSituacaoByMesAno(entidade, dataInicio, dataFim);
        return movimentacaoDiaria.stream().map(MovimentacaoDiariaDTO::from).collect(Collectors.toList());
    }

    public MovimentacaoDiariaDTO findSituacaoByDataMovimento(String dataMovimento) {
        Long entidade = this.contextService.getEntidadePrincipal();
        MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaRepository.findSituacaoByDataMovimento(entidade, LocalDate.parse(dataMovimento, formatterDate));
        return MovimentacaoDiariaDTO.from((MovimentacaoDiaria)movimentacaoDiaria);
    }

    public MovimentacaoDiaria findOrCreateMovimentacaoDiaria(MovimentacaoDiariaId id) {
        String usuario = SecurityUtils.getUserAise();
        return this.findOrCreateMovimentacaoDiaria(id, usuario);
    }

    public MovimentacaoDiaria findOrCreateMovimentacaoDiaria(MovimentacaoDiariaId id, String usuario) {
        MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaRepository.findSituacaoByDataMovimento(id.getEntidade(), id.getData());
        if (Objects.isNull(movimentacaoDiaria)) {
            return this.createMovimentacaoDiaria(id, usuario);
        }
        return movimentacaoDiaria;
    }

    private MovimentacaoDiaria createMovimentacaoDiaria(MovimentacaoDiariaId id, String usuario) {
        MovimentacaoDiaria movimentacaoDiaria = new MovimentacaoDiaria();
        movimentacaoDiaria.setId(id);
        movimentacaoDiaria.setSituacao(SituacaoMovimentacaoDiaria.ABERTO);
        movimentacaoDiaria.setDataAbertura(id.getData());
        movimentacaoDiaria.setUsuarioAbertura(usuario);
        return (MovimentacaoDiaria)this.movimentacaoDiariaRepository.save((Object)movimentacaoDiaria);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized List<MovimentacaoDiaria> verificaSituacaoParaIntegracaoContabil(List<LocalDate> datasMovimento, String usuario) {
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        List movimentacoesDiarias = datasMovimento.stream().map(dataMovimento -> {
            MovimentacaoDiariaId id = new MovimentacaoDiariaId();
            id.setEntidade(entidadePrincipal);
            id.setData(dataMovimento);
            return this.findOrCreateMovimentacaoDiaria(id, usuario);
        }).collect(Collectors.toList());
        String datasAbertas = movimentacoesDiarias.stream().filter(movimentacaoDiaria -> !SituacaoMovimentacaoDiaria.TRIBUTACAO.equals((Object)movimentacaoDiaria.getSituacao())).map(movimentacaoDiaria -> movimentacaoDiaria.getId().getData().format(formatterUserDate)).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)datasAbertas)) {
            throw new EloValidationException(String.format("S\u00f3 \u00e9 permitida a integra\u00e7\u00e3o com a contabilidade se data estiver com situa\u00e7\u00e3o %s. Verifique a(s) data(s) %s.", SituacaoMovimentacaoDiaria.TRIBUTACAO.getDescricao(), datasAbertas));
        }
        return this.updateSituacaoMovimentacoesDiarias(movimentacoesDiarias, SituacaoMovimentacaoDiaria.GERANDO_MOVIMENTACAO);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<MovimentacaoDiaria> updateSituacaoMovimentacoesDiarias(List<MovimentacaoDiaria> movimentacoesDiarias, SituacaoMovimentacaoDiaria situacao) {
        return movimentacoesDiarias.stream().map(movimentacaoDiaria -> {
            movimentacaoDiaria.setSituacao(situacao);
            return (MovimentacaoDiaria)this.movimentacaoDiariaRepository.save(movimentacaoDiaria);
        }).collect(Collectors.toList());
    }

    public void integrarData(List<MovimentacaoDiaria> movimentacoesDiarias) {
        movimentacoesDiarias.forEach(movimentacaoDiaria -> {
            movimentacaoDiaria.setSituacao(SituacaoMovimentacaoDiaria.CONTABILIDADE);
            this.movimentacaoDiariaRepository.save(movimentacaoDiaria);
        });
    }

    public void reverterIntegracaoData(LocalDate dataToUpdate) {
        MovimentacaoDiaria movimentacaoDiaria = (MovimentacaoDiaria)this.movimentacaoDiariaRepository.findById((Object)MovimentacaoDiariaId.builder().entidade(this.contextService.getEntidadePrincipal()).data(dataToUpdate).build()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a data de movimenta\u00e7\u00e3o: %s.", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)dataToUpdate))));
        movimentacaoDiaria.setSituacao(SituacaoMovimentacaoDiaria.TRIBUTACAO);
        this.movimentacaoDiariaRepository.save((Object)movimentacaoDiaria);
    }
}

