/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.exception.MotivoDeducaoException;
import br.com.elotech.tributos.repository.MotivoDeducaoRepository;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class MotivoDeducaoService
extends CrudService<MotivoDeducao, Long> {
    private final MotivoDeducaoRepository motivoDeducaoRepository;

    public MotivoDeducaoService(MotivoDeducaoRepository motivoDeducaoRepository) {
        this.motivoDeducaoRepository = motivoDeducaoRepository;
    }

    public MotivoDeducao findByMotivoId(Long id) {
        this.validaMotivoMovimentacao(id);
        return (MotivoDeducao)this.getCrudRepository().findOne((Object)id);
    }

    public void validaMotivoMovimentacao(Long motivoId) {
        Boolean motivoDeducao = this.motivoDeducaoRepository.existsMotivoMovimentacao(motivoId);
        if (motivoDeducao.booleanValue()) {
            throw new MotivoDeducaoException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o \u00e9 poss\u00edvel alterar o motivo %d, pois j\u00e1 existe movimenta\u00e7\u00e3o cont\u00e1bil", motivoId));
        }
    }

    protected void beforeDelete(MotivoDeducao entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        this.validaMotivoMovimentacao(entity.getId());
    }

    protected void beforeEdit(MotivoDeducao entity) {
        super.beforeEdit((EloEntity)entity);
        this.validaMotivoMovimentacao(entity.getId());
    }
}

