/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributoId;
import br.com.elotech.tributos.repository.LivroParcelaTributoRepository;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LivroParcelaTributoService
extends CrudService<LivroParcelaTributo, LivroParcelaTributoId> {
    private final LivroParcelaTributoRepository livroParcelaTributoRepository;

    public LivroParcelaTributoService(LivroParcelaTributoRepository livroParcelaTributoRepository) {
        this.livroParcelaTributoRepository = livroParcelaTributoRepository;
    }

    public List<LivroParcelaTributo> findByLivro(Long entidade, Long exercicio, Long livro) {
        List livroParcelaTributos = this.livroParcelaTributoRepository.findByEntidadeAndExercicioAndLivro(entidade, exercicio, livro);
        if (livroParcelaTributos.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar os d\u00e9bitos do livro %d/%d", livro, exercicio));
        }
        return livroParcelaTributos;
    }

    public List<LivroParcelaTributo> findByLivroRegistro(Long entidade, Long exercicio, Long livro, Long sequencia) {
        List livroParcelaTributos = this.livroParcelaTributoRepository.findByEntidadeAndExercicioAndLivroAndSequencia(entidade, exercicio, livro, sequencia);
        if (livroParcelaTributos.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar os d\u00e9bitos do livro %d/%d", livro, exercicio));
        }
        return livroParcelaTributos;
    }

    public void updateSituacaoEstornado(LivroParcelaTributo livroParcelasTributos) {
        livroParcelasTributos.setEstornado(Boolean.TRUE);
        this.livroParcelaTributoRepository.save((Object)livroParcelasTributos);
    }
}

