/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.domain.ImobiliariaCadastro;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.ImobiliariaCadastroDTO;
import br.com.elotech.tributos.repository.ImobiliariaCadastroRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ImobiliariaService;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ImobiliariaCadastroService
extends ReadOnlyService<ImobiliariaCadastro, Long> {
    private final ImobiliariaCadastroRepository imobiliariaCadastroRepository;
    private final CadastroGeralService cadastroGeralService;
    private final ImobiliariaService imobiliariaService;

    public ImobiliariaCadastroService(ImobiliariaCadastroRepository imobiliariaCadastroRepository, CadastroGeralService cadastroGeralService, ImobiliariaService imobiliariaService) {
        this.imobiliariaCadastroRepository = imobiliariaCadastroRepository;
        this.cadastroGeralService = cadastroGeralService;
        this.imobiliariaService = imobiliariaService;
    }

    public ImobiliariaCadastroDTO save(ImobiliariaCadastroDTO imobiliariaCadastroDTO) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)imobiliariaCadastroDTO.getTipoCadastro()), imobiliariaCadastroDTO.getCadastroGeral()).orElseThrow(() -> new EloValidationException(String.format("Cadastro %d/%d n\u00e3o encontrado!", imobiliariaCadastroDTO.getTipoCadastro(), imobiliariaCadastroDTO.getCadastroGeral())));
        Imobiliaria imobiliaria = (Imobiliaria)this.imobiliariaService.findById((Serializable)imobiliariaCadastroDTO.getIdImobiliaria()).orElseThrow(() -> new EloValidationException(String.format("Imobili\u00e1ria %d n\u00e3o encontrada!", imobiliariaCadastroDTO.getIdImobiliaria())));
        if (this.imobiliariaCadastroRepository.findByCadastroGeralIdAndImobiliariaId(cadastroGeral.getId(), imobiliaria.getId()).stream().anyMatch(cadastro -> !cadastro.getId().equals(imobiliariaCadastroDTO.getId()) && Objects.isNull(cadastro.getDataExclusaoVinculo()))) {
            throw new EloValidationException("Cadastro j\u00e1 vinculado \u00e0 imobili\u00e1ria!");
        }
        ImobiliariaCadastro imobiliariaCadastro = new ImobiliariaCadastro();
        imobiliariaCadastro.setId(imobiliariaCadastroDTO.getId());
        imobiliariaCadastro.setDataInclusaoVinculo(imobiliariaCadastroDTO.getDataInclusaoVinculo());
        imobiliariaCadastro.setDataExclusaoVinculo(imobiliariaCadastroDTO.getDataExclusaoVinculo());
        imobiliariaCadastro.setCadastroGeral(cadastroGeral);
        imobiliariaCadastro.setImobiliaria(imobiliaria);
        return ImobiliariaCadastroDTO.of((ImobiliariaCadastro)((ImobiliariaCadastro)this.imobiliariaCadastroRepository.save((Object)imobiliariaCadastro)));
    }

    public ImobiliariaCadastroDTO edit(Long id, ImobiliariaCadastroDTO imobiliariaCadastroDTO) {
        ImobiliariaCadastro imobiliariaCadastro = (ImobiliariaCadastro)this.imobiliariaCadastroRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro %d n\u00e3o encontrado na imobili\u00e1ria %d!", id, imobiliariaCadastroDTO.getIdImobiliaria())));
        imobiliariaCadastro.setDataInclusaoVinculo(imobiliariaCadastroDTO.getDataInclusaoVinculo());
        imobiliariaCadastro.setDataExclusaoVinculo(imobiliariaCadastroDTO.getDataExclusaoVinculo());
        return ImobiliariaCadastroDTO.of((ImobiliariaCadastro)((ImobiliariaCadastro)this.imobiliariaCadastroRepository.save((Object)imobiliariaCadastro)));
    }

    public void delete(Long id) {
        this.imobiliariaCadastroRepository.deleteById((Object)id);
    }
}

