/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.EstornoPagamento;
import br.com.elotech.tributos.domain.EstornoPagamentoId;
import br.com.elotech.tributos.domain.EstornoPagamentoItem;
import br.com.elotech.tributos.domain.EstornoPagamentoItemId;
import br.com.elotech.tributos.domain.EstornoPagamentoLote;
import br.com.elotech.tributos.domain.EstornoPagamentoLoteItem;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.dto.DetalheEstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.ReabilitacaoEstornoPagamentoDTO;
import br.com.elotech.tributos.repository.EstornoPagamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.EstornoPagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoDebitoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class EstornoPagamentoService
extends CrudService<EstornoPagamento, EstornoPagamentoId> {
    private final EstornoPagamentoRepository estornoPagamentoRepository;
    private final ContextService contextService;
    private final PagamentoService pagamentoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final PagamentoDebitoService pagamentoDebitoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final EstornoPagamentoLoteService estornoPagamentoLoteService;

    public EstornoPagamentoService(EstornoPagamentoRepository estornoPagamentoRepository, ContextService contextService, PagamentoService pagamentoService, ValidaDataMovimentacaoService validaDataMovimentacaoService, PagamentoDebitoService pagamentoDebitoService, DebitoParcelaService debitoParcelaService, DebitoService debitoService, DebitoObservacaoService debitoObservacaoService, EstornoPagamentoLoteService estornoPagamentoLoteService) {
        this.estornoPagamentoRepository = estornoPagamentoRepository;
        this.contextService = contextService;
        this.pagamentoService = pagamentoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.pagamentoDebitoService = pagamentoDebitoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.estornoPagamentoLoteService = estornoPagamentoLoteService;
    }

    public List<DetalheEstornoPagamentoDTO> getEstornoPagamentosById(Long entidade, Long exercicioPagamento, Long pagamento) {
        List estornoPagamento = this.estornoPagamentoRepository.findEstornoPagamentoByPagamento(entidade, exercicioPagamento, pagamento);
        return estornoPagamento.stream().map(DetalheEstornoPagamentoDTO::of).collect(Collectors.toList());
    }

    public void estornarPagamento(EstornoPagamentoDTO estornoPagamentoDTO) {
        if (estornoPagamentoDTO.getTodosSelecionados().booleanValue()) {
            if (Objects.isNull(estornoPagamentoDTO.getFiltro())) {
                throw new EloValidationException("\u00c9 obrigat\u00f3rio informar o filtro quando todos os pagamentos estiverem selecionados.");
            }
        } else if (estornoPagamentoDTO.getSelecionados().isEmpty()) {
            throw new EloValidationException("\u00c9 obrigat\u00f3rio informar pelo menos um pagamento.");
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        this.validaDataMovimentacaoService.validaMesEDia(entidade, estornoPagamentoDTO.getData());
        List pagamentosParaEstornar = this.findPagamentosParaEstornar(entidade, estornoPagamentoDTO);
        if (pagamentosParaEstornar.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar pagamentos com os filtros informados.");
        }
        if (pagamentosParaEstornar.stream().anyMatch(pagamento -> estornoPagamentoDTO.getData().isBefore(pagamento.getDataMovimento()))) {
            throw new EloValidationException("A data do estorno deve ser maior que a data de lancamento de todos os pagamentos selecionados.");
        }
        if (pagamentosParaEstornar.size() == 1) {
            this.criarEstornoPagamento(entidade, exercicio, estornoPagamentoDTO, (Pagamento)pagamentosParaEstornar.get(0));
        } else {
            this.criarEstornoPagamentoLote(entidade, exercicio, estornoPagamentoDTO, pagamentosParaEstornar);
        }
    }

    private List<Pagamento> findPagamentosParaEstornar(Long entidade, EstornoPagamentoDTO estornoPagamentoDTO) {
        if (estornoPagamentoDTO.getTodosSelecionados().booleanValue()) {
            estornoPagamentoDTO.setTodosSelecionados(Boolean.TRUE);
            return this.pagamentoService.searchPagamentos(estornoPagamentoDTO.getFiltro());
        }
        List pagamentoIds = estornoPagamentoDTO.getSelecionados().stream().map(selecionado -> {
            PagamentoId pagamentoId = new PagamentoId();
            pagamentoId.setEntidade(entidade);
            pagamentoId.setExercicioPagamento(selecionado.getExercicio());
            pagamentoId.setPagamento(selecionado.getPagamento());
            return pagamentoId;
        }).collect(Collectors.toList());
        return this.pagamentoService.findAllById(pagamentoIds);
    }

    private EstornoPagamento criarEstornoPagamento(Long entidade, Long exercicio, EstornoPagamentoDTO estornoPagamentoDTO, Pagamento pagamento) {
        this.validatePagamento(pagamento);
        EstornoPagamentoId estornoPagamentoId = new EstornoPagamentoId();
        estornoPagamentoId.setEntidade(entidade);
        estornoPagamentoId.setExercicio(exercicio);
        EstornoPagamento estornoPagamento = new EstornoPagamento();
        estornoPagamento.setId(estornoPagamentoId);
        estornoPagamento.setPagamento(pagamento);
        estornoPagamento.setDataEstorno(estornoPagamentoDTO.getData());
        estornoPagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        estornoPagamento.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamento.setContaBancariaEstorno(pagamento.getContaBancaria().getContaBancaria());
        estornoPagamento.setIdProcesso(estornoPagamentoDTO.getNumeroProcesso());
        estornoPagamento.setExercicioProcesso(estornoPagamentoDTO.getAnoProcesso());
        estornoPagamento.setMotivoDeducao(estornoPagamentoDTO.getMotivoDeducao());
        EstornoPagamento saved = (EstornoPagamento)this.save((EloEntity)estornoPagamento, null);
        this.geraEstornoPagamentoItens(pagamento, saved);
        this.adicionaObservacaoDebito(saved, Boolean.valueOf(true));
        return (EstornoPagamento)this.save((EloEntity)saved, null);
    }

    private EstornoPagamentoLote criarEstornoPagamentoLote(Long entidade, Long exercicio, EstornoPagamentoDTO estornoPagamentoDTO, List<Pagamento> pagamentos) {
        EstornoPagamentoLote estornoPagamentoLote = new EstornoPagamentoLote();
        estornoPagamentoLote.setDataInclusao(estornoPagamentoDTO.getData());
        estornoPagamentoLote.setEntidade(entidade);
        estornoPagamentoLote.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamentoLote.setUsuario(SecurityUtils.getUserAise());
        estornoPagamentoLote.setIdProcesso(estornoPagamentoDTO.getNumeroProcesso());
        estornoPagamentoLote.setExercicioProcesso(estornoPagamentoDTO.getAnoProcesso());
        pagamentos.forEach(pagamento -> {
            EstornoPagamento estornoPagamento = this.criarEstornoPagamento(entidade, exercicio, estornoPagamentoDTO, pagamento);
            EstornoPagamentoLoteItem estornoPagamentoLoteItem = new EstornoPagamentoLoteItem();
            estornoPagamentoLoteItem.setEstornoPagamento(estornoPagamento);
            estornoPagamentoLoteItem.setLote(estornoPagamentoLote);
            estornoPagamentoLote.getItens().add(estornoPagamentoLoteItem);
        });
        return (EstornoPagamentoLote)this.estornoPagamentoLoteService.save((EloEntity)estornoPagamentoLote, null);
    }

    private void validatePagamento(Pagamento pagamento) {
        if (pagamento.getPagamentoBoleto().getPagamentosDebito().stream().anyMatch(PagamentoDebito::getEstorno)) {
            throw new EloValidationException(String.format("O pagamento %d/%d j\u00e1 est\u00e1 estornado.", pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento()));
        }
    }

    private void geraEstornoPagamentoItens(Pagamento pagamento, EstornoPagamento estorno) {
        AtomicLong sequenciaEstornoPagamentoItem = new AtomicLong(1L);
        pagamento.getPagamentoBoleto().getPagamentosDebito().forEach(pagamentoDebito -> {
            EstornoPagamentoItemId estornoPagamentoItemId = new EstornoPagamentoItemId();
            estornoPagamentoItemId.setEntidade(estorno.getId().getEntidade());
            estornoPagamentoItemId.setExercicio(estorno.getId().getExercicio());
            estornoPagamentoItemId.setEstorno(estorno.getId().getEstorno());
            estornoPagamentoItemId.setSequencia(Long.valueOf(sequenciaEstornoPagamentoItem.getAndIncrement()));
            EstornoPagamentoItem estornoPagamentoItem = new EstornoPagamentoItem();
            estornoPagamentoItem.setId(estornoPagamentoItemId);
            estornoPagamentoItem.setIdPagamentoBoleto(pagamento.getPagamentoBoleto().getId());
            estornoPagamentoItem.setIdDebitoParcelaTributo(pagamentoDebito.getId().getDebitoParcelaTributo().getId());
            estornoPagamentoItem.setEstornoPagamento(estorno);
            estorno.getEstornoPagamentoItems().add(estornoPagamentoItem);
            pagamentoDebito.setEstorno(Boolean.TRUE);
            pagamentoDebito.setDataEstorno(estorno.getDataEstorno());
            this.pagamentoDebitoService.save((EloEntity)pagamentoDebito, null);
            this.updateSituacaoParcela(pagamento, pagamentoDebito);
        });
    }

    private void updateSituacaoParcela(Pagamento pagamento, PagamentoDebito pagamentoDebito) {
        if (!this.pagamentoService.existePagamentoNaoEstornadoParaMesmaParcelaTributo(pagamento, pagamentoDebito.getId().getDebitoParcelaTributo()).booleanValue()) {
            this.debitoParcelaService.abrirParcela(pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela());
        }
    }

    public EstornoPagamento reabilitarEstorno(EstornoPagamentoId estornoPagamentoId, ReabilitacaoEstornoPagamentoDTO reabilitacaDTO) {
        EstornoPagamento estornoPagamento = (EstornoPagamento)this.findById((Serializable)estornoPagamentoId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o estorno %d no exercicio %d na entidade %d.", estornoPagamentoId.getEstorno(), estornoPagamentoId.getExercicio(), estornoPagamentoId.getEntidade())));
        if (estornoPagamento.getReabilitado().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido reabilitar pagamento habilitado.");
        }
        this.validaDataMovimentacaoService.validaMesEDia(estornoPagamento.getId().getEntidade(), reabilitacaDTO.getData());
        estornoPagamento.setReabilitado(Boolean.TRUE);
        estornoPagamento.setDataReabilitacao(reabilitacaDTO.getData());
        estornoPagamento.setMotivoReabilitacao(reabilitacaDTO.getMotivo());
        estornoPagamento.getPagamento().getPagamentoBoleto().getPagamentosDebito().forEach(pagamentoDebito -> {
            pagamentoDebito.setEstorno(Boolean.valueOf(false));
            pagamentoDebito.setDataEstorno(null);
            if (!estornoPagamento.getPagamento().getPagoAMenor().booleanValue()) {
                DebitoParcela debitoParcela = pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela();
                this.debitoParcelaService.pagarParcela(debitoParcela);
            }
        });
        this.adicionaObservacaoDebito(estornoPagamento, Boolean.valueOf(false));
        return (EstornoPagamento)this.save((EloEntity)estornoPagamento, null);
    }

    private void adicionaObservacaoDebito(EstornoPagamento estornoPagamento, Boolean isEstorno) {
        PagamentoId pagamentoId = estornoPagamento.getPagamento().getId();
        List debitosId = this.debitoService.findDebitosIdRelacionadosPagamento(pagamentoId.getEntidade(), pagamentoId.getExercicioPagamento(), pagamentoId.getPagamento());
        String observacao = String.format("%sEstorno de Pagamento %d/%d do Pagamento %d/%d. %s", isEstorno != false ? "" : "Reabilita\u00e7\u00e3o de ", estornoPagamento.getId().getEstorno(), estornoPagamento.getId().getExercicio(), pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento(), isEstorno != false ? estornoPagamento.getMotivoEstorno() : estornoPagamento.getMotivoReabilitacao());
        debitosId.forEach(debitoIdDTO -> this.debitoObservacaoService.save(debitoIdDTO, observacao));
    }
}

